/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class LicenseJohnsonEventRaiserImpl
implements LicenseJohnsonEventRaiser {
    private static final Logger log = Logger.getLogger(LicenseJohnsonEventRaiserImpl.class);
    private final BuildUtilsInfo buildUtilsInfo;
    private static final int V1 = 1;

    public LicenseJohnsonEventRaiserImpl(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    @Override
    public boolean checkLicenseIsTooOldForBuild(ServletContext servletContext, LicenseDetails licenseDetails) {
        boolean shouldRaiseEvent;
        boolean bl = shouldRaiseEvent = licenseDetails.isLicenseSet() && licenseDetails.getLicenseVersion() > 1 && !licenseDetails.isMaintenanceValidForBuildDate(this.buildUtilsInfo.getCurrentBuildDate()) && !licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone();
        if (shouldRaiseEvent) {
            log.error((Object)("The current license is too old (" + licenseDetails.getMaintenanceEndString(new OutlookDate(Locale.getDefault())) + ") to run this version (" + this.buildUtilsInfo.getVersion() + " - " + this.buildUtilsInfo.getCurrentBuildDate() + ") of JIRA."));
            JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)servletContext);
            Event newEvent = new Event(EventType.get((String)"license-too-old"), "The current license is too old to install this version of JIRA (" + this.buildUtilsInfo.getVersion() + ")", EventLevel.get((String)"error"));
            cont.addEvent(newEvent);
        }
        return shouldRaiseEvent;
    }
}

