/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class StatusCategoryClauseValuesGenerator
implements ClauseValuesGenerator {
    private final StatusCategoryManager statusCategoryManager;

    public StatusCategoryClauseValuesGenerator(StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = statusCategoryManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List statusCategories = this.statusCategoryManager.getUserVisibleStatusCategories();
        ArrayList<ClauseValuesGenerator.Result> results = new ArrayList<ClauseValuesGenerator.Result>(Math.min(statusCategories.size(), maxNumResults));
        for (StatusCategory statusCategory : statusCategories) {
            if (results.size() == maxNumResults) break;
            String categoryName = statusCategory.getName();
            String lowerCaseCategoryName = categoryName.toLowerCase();
            if (!StringUtils.isBlank((String)valuePrefix) && !lowerCaseCategoryName.startsWith(valuePrefix.toLowerCase())) continue;
            results.add(new ClauseValuesGenerator.Result(categoryName));
        }
        return new ClauseValuesGenerator.Results(results);
    }

    Locale getLocale(User searcher) {
        return new I18nBean(searcher).getLocale();
    }
}

