/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.StatusCategoryResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.List;

@InjectableComponent
public class StatusCategoryValidator
implements ClauseValidator {
    private final StatusCategoryResolver statusCategoryResolver;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;

    public StatusCategoryValidator(JqlOperandResolver jqlOperandResolver, StatusCategoryResolver statusCategoryResolver) {
        this.statusCategoryResolver = (StatusCategoryResolver)Assertions.notNull((String)"statusCategoryResolver", (Object)statusCategoryResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        Operand operand;
        List rawValues;
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors() && (rawValues = this.jqlOperandResolver.getValues(searcher, operand = terminalClause.getOperand(), terminalClause)) != null) {
            I18nHelper i18n = this.getI18n(searcher);
            for (QueryLiteral rawValue : rawValues) {
                Option<StatusCategory> statusCategory;
                if (rawValue.isEmpty() || (statusCategory = this.statusCategoryResolver.getStatusCategory(rawValue)).isDefined()) continue;
                if (rawValue.getLongValue() != null) {
                    if (this.jqlOperandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                        messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), terminalClause.getName()));
                        continue;
                    }
                    messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.id", terminalClause.getName(), rawValue.toString()));
                    continue;
                }
                if (rawValue.getStringValue() == null) continue;
                if (this.jqlOperandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), terminalClause.getName()));
                    continue;
                }
                messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name", terminalClause.getName(), rawValue.toString()));
            }
        }
        return messageSet;
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

