/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueKeySupport;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.IssueIdValidator;
import com.atlassian.jira.jql.validator.MovedIssueValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import javax.annotation.Nonnull;

@InjectableComponent
public class IssueParentValidator
implements ClauseValidator {
    private final SubTaskManager subTaskManager;
    private final IssueIdValidator issueIdValidator;
    private final I18nHelper.BeanFactory i18nFactory;

    IssueParentValidator(IssueIdValidator issueIdValidator, SubTaskManager subTaskManager, I18nHelper.BeanFactory i18nFactory) {
        this.issueIdValidator = (IssueIdValidator)Assertions.notNull((String)"issueIdValidator", (Object)issueIdValidator);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
    }

    public IssueParentValidator(JqlOperandResolver operandResolver, JqlIssueKeySupport issueKeySupport, JqlIssueSupport issueSupport, I18nHelper.BeanFactory i18nFactory, MovedIssueKeyStore moveIssueKeyStore, SubTaskManager subTaskManager) {
        this(new IssueIdValidator(operandResolver, issueKeySupport, issueSupport, i18nFactory, new SupportedOperatorsValidator(new Collection[]{SystemSearchConstants.forIssueParent().getSupportedOperators()}), new MovedIssueValidator(OperatorClasses.EQUALITY_OPERATORS, moveIssueKeyStore, i18nFactory)), subTaskManager, i18nFactory);
    }

    @Nonnull
    public MessageSet validate(User searcher, @Nonnull TerminalClause terminalClause) {
        Assertions.notNull((String)"terminalClause", (Object)terminalClause);
        if (!this.subTaskManager.isSubTasksEnabled()) {
            MessageSetImpl messageSet = new MessageSetImpl();
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.issue.parent.subtasks.disabled", terminalClause.getName()));
            return messageSet;
        }
        return this.issueIdValidator.validate(searcher, terminalClause);
    }
}

