/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.changehistory.JqlChangeItemMapping;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;

public class HistoryFieldValueValidator {
    private final SearchHandlerManager searchHandlerManager;
    private final JqlChangeItemMapping jqlChangeItemMapping;
    private final ChangeHistoryManager changeHistoryManager;
    private final JqlOperandResolver operandResolver;
    private final ChangeHistoryFieldConfigurationManager configurationManager;
    private final SearchProviderFactory searchProviderFactory;

    public HistoryFieldValueValidator(SearchHandlerManager searchHandlerManager, JqlChangeItemMapping jqlChangeItemMapping, ChangeHistoryManager changeHistoryManager, JqlOperandResolver operandResolver, ChangeHistoryFieldConfigurationManager configurationManager, SearchProviderFactory searchProviderFactory) {
        this.searchHandlerManager = searchHandlerManager;
        this.jqlChangeItemMapping = jqlChangeItemMapping;
        this.changeHistoryManager = changeHistoryManager;
        this.operandResolver = operandResolver;
        this.configurationManager = configurationManager;
        this.searchProviderFactory = searchProviderFactory;
    }

    private boolean stringValueExists(PossibleValuesHolder possibleValuesHolder, User searcher, String fieldName, String rawValue) {
        ClauseHandler clauseHandler;
        String valuePrefix = "";
        Collection clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = (ClauseHandler)clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            if (possibleValuesHolder.getCurrentValues() == null) {
                ClauseValuesGenerator.Results generatorResults = ((ValueGeneratingClauseHandler)clauseHandler).getClauseValuesGenerator().getPossibleValues(searcher, this.jqlChangeItemMapping.mapJqlClauseToFieldName(fieldName), "", Integer.MAX_VALUE);
                List list = generatorResults.getResults();
                HashSet<String> possibleValues = new HashSet<String>(list.size());
                for (ClauseValuesGenerator.Result result : list) {
                    possibleValues.add(result.getValue().toLowerCase());
                }
                possibleValuesHolder.setCurrentValues(possibleValues);
            }
            if (!possibleValuesHolder.getCurrentValues().contains(rawValue.toLowerCase())) {
                if (possibleValuesHolder.getHistoricalValues() == null) {
                    Set<String> possibleValuesSet = this.findAllPossibleFieldTerms(searcher, fieldName.toLowerCase());
                    possibleValuesHolder.setHistoricalValues(possibleValuesSet);
                }
                return possibleValuesHolder.getHistoricalValues().contains(rawValue.toLowerCase());
            }
            return possibleValuesHolder.getCurrentValues().contains(rawValue.toLowerCase());
        }
        return false;
    }

    private Set<String> findAllPossibleFieldTerms(User searcher, String fieldName) {
        HashSet values = Sets.newHashSet();
        JiraLuceneFieldFinder luceneFieldFinder = JiraLuceneFieldFinder.getInstance();
        try {
            IndexReader reader = this.searchProviderFactory.getSearcher("changes").getIndexReader();
            List oldValues = luceneFieldFinder.getTermValuesForField(reader, fieldName + "." + "ch_from");
            List newValues = luceneFieldFinder.getTermValuesForField(reader, fieldName + "." + "ch_to");
            values.addAll(oldValues);
            values.addAll(newValues);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return this.stripProtocol(values);
    }

    private Set<String> stripProtocol(Set<String> values) {
        HashSet newValues = Sets.newHashSetWithExpectedSize((int)values.size());
        int index = "ch-".length();
        for (String value : values) {
            newValues.add(value.substring(index));
        }
        return newValues;
    }

    public MessageSet validateValues(User searcher, String fieldName, List<QueryLiteral> rawValues) {
        PossibleValuesHolder possibleValuesHolder = new PossibleValuesHolder();
        MessageSetImpl messages = new MessageSetImpl();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.getStringValue() != null) {
                if (this.stringValueExists(possibleValuesHolder, searcher, fieldName, rawValue.getStringValue())) continue;
                if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                    continue;
                }
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", fieldName, rawValue.getStringValue()));
                continue;
            }
            if (rawValue.getLongValue() == null) continue;
            if (this.stringValueExists(possibleValuesHolder, searcher, fieldName, rawValue.getLongValue().toString())) {
                return messages;
            }
            if (!this.configurationManager.supportsIdSearching(fieldName.toLowerCase())) {
                if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                    messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                    continue;
                }
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.history.clause.not.string", rawValue.getSourceOperand().getName(), fieldName));
                continue;
            }
            if (this.longValueExists(searcher, fieldName, rawValue.getLongValue())) continue;
            if (this.operandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), fieldName));
                continue;
            }
            messages.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.no.value.for.id", fieldName, rawValue.getLongValue().toString()));
        }
        return messages;
    }

    private boolean longValueExists(User searcher, String fieldName, Long longValue) {
        NameResolver resolver = this.configurationManager.getNameResolver(fieldName.toLowerCase());
        return resolver.idExists(longValue);
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }

    private class PossibleValuesHolder {
        Set<String> currentValues = null;
        Set<String> historicalValues = null;

        private PossibleValuesHolder() {
        }

        private Set<String> getCurrentValues() {
            return this.currentValues;
        }

        private void setCurrentValues(Set<String> currentValues) {
            this.currentValues = currentValues;
        }

        private Set<String> getHistoricalValues() {
            return this.historicalValues;
        }

        private void setHistoricalValues(Set<String> historicalValues) {
            this.historicalValues = historicalValues;
        }
    }
}

