/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.validator.FreeTextFieldValidator;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import javax.annotation.Nonnull;

public class CommentValidator
extends FreeTextFieldValidator {
    private final JqlOperandResolver jqlOperandResolver;

    public CommentValidator(JqlOperandResolver jqlOperandResolver) {
        super(SystemSearchConstants.forComments().getIndexField(), jqlOperandResolver);
        this.jqlOperandResolver = jqlOperandResolver;
    }

    @Nonnull
    public MessageSet validate(User searcher, @Nonnull TerminalClause terminalClause) {
        if (this.jqlOperandResolver.isEmptyOperand(terminalClause.getOperand())) {
            MessageSetImpl messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.field.does.not.support.empty", terminalClause.getName()));
            return messageSet;
        }
        return super.validate(searcher, terminalClause);
    }
}

