/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SavedFilterResolver {
    private final SearchRequestManager searchRequestManager;

    public SavedFilterResolver(SearchRequestManager searchRequestManager) {
        this.searchRequestManager = (SearchRequestManager)Assertions.notNull((String)"searchRequestManager", (Object)searchRequestManager);
    }

    public List<SearchRequest> getSearchRequest(User searcher, List<QueryLiteral> rawValues) {
        return this._getSearchRequests(ApplicationUsers.from((User)searcher), false, rawValues);
    }

    public List<SearchRequest> getSearchRequestOverrideSecurity(List<QueryLiteral> rawValues) {
        return this._getSearchRequests(null, true, rawValues);
    }

    private List<SearchRequest> _getSearchRequests(ApplicationUser searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        ArrayList<SearchRequest> matchingFilters = new ArrayList<SearchRequest>();
        if (rawValues != null) {
            for (QueryLiteral rawValue : rawValues) {
                if (rawValue.getStringValue() != null) {
                    matchingFilters.addAll(this.getSearchRequestsForString(searcher, overrideSecurity, rawValue.getStringValue()));
                    continue;
                }
                if (rawValue.getLongValue() == null) continue;
                matchingFilters.addAll(this.getSearchRequestsForLong(searcher, overrideSecurity, rawValue.getLongValue()));
            }
        }
        return matchingFilters;
    }

    private List<SearchRequest> getSearchRequestsForLong(ApplicationUser searcher, boolean overrideSecurity, Long rawValue) {
        ArrayList<SearchRequest> valuesMatchingFilters = new ArrayList<SearchRequest>();
        SearchRequest request = this.getSearchRequestById(searcher, overrideSecurity, rawValue);
        if (request != null) {
            valuesMatchingFilters.add(request);
        } else {
            valuesMatchingFilters.addAll(this.getSearchRequestsByName(searcher, overrideSecurity, rawValue.toString()));
        }
        return valuesMatchingFilters;
    }

    private List<SearchRequest> getSearchRequestsForString(ApplicationUser searcher, boolean overrideSecurity, String rawValue) {
        SearchRequest request;
        Long valueAsLong;
        List<SearchRequest> valuesMatchingFilters = this.getSearchRequestsByName(searcher, overrideSecurity, rawValue);
        if (valuesMatchingFilters.isEmpty() && (valueAsLong = this.getValueAsLong(rawValue)) != null && (request = this.getSearchRequestById(searcher, overrideSecurity, valueAsLong)) != null) {
            valuesMatchingFilters.add(request);
        }
        return valuesMatchingFilters;
    }

    private SearchRequest getSearchRequestById(ApplicationUser searcher, boolean overrideSecurity, Long idValue) {
        if (!overrideSecurity) {
            return this.searchRequestManager.getSearchRequestById(searcher, idValue);
        }
        return this.searchRequestManager.getSearchRequestById(idValue);
    }

    private List<SearchRequest> getSearchRequestsByName(ApplicationUser searcher, boolean overrideSecurity, String nameValue) {
        String trimName = StringUtils.trimToNull((String)nameValue);
        if (trimName != null) {
            if (!overrideSecurity) {
                SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder().setName(nameValue).setTextSearchMode(SharedEntitySearchParameters.TextSearchMode.EXACT).setEntitySearchContext(SharedEntitySearchContext.USE);
                SharedEntitySearchResult sharedEntitySearchResult = this.searchRequestManager.search(builder.toSearchParameters(), searcher, 0, Integer.MAX_VALUE);
                return sharedEntitySearchResult.getResults();
            }
            return this.searchRequestManager.findByNameIgnoreCase(nameValue);
        }
        return Collections.emptyList();
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

