/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.ActualValueRelationalQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.DateEqualityQueryFactory;
import com.atlassian.jira.jql.query.DateRelationalQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.LikeQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.NumberIndexValueConverter;
import com.atlassian.jira.jql.util.SimpleIndexValueConverter;
import com.atlassian.jira.jql.validator.IssuePropertyClauseValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

@InjectableComponent
public class IssuePropertyClauseQueryFactory
implements ClauseQueryFactory {
    private final PluginIndexConfigurationManager pluginIndexConfigurationManager;
    private final DoubleConverter doubleConverter;
    private final JqlDateSupport jqlDateSupport;
    private final JqlOperandResolver operandResolver;
    private final JiraAuthenticationContext authenticationContext;

    public IssuePropertyClauseQueryFactory(PluginIndexConfigurationManager pluginIndexConfigurationManager, DoubleConverter doubleConverter, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext) {
        this.pluginIndexConfigurationManager = pluginIndexConfigurationManager;
        this.doubleConverter = doubleConverter;
        this.jqlDateSupport = jqlDateSupport;
        this.operandResolver = operandResolver;
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        if (terminalClause.getProperty().isDefined() && IssuePropertyClauseValidator.isSupportedOperator(terminalClause.getOperator())) {
            return this.getLuceneQuery(terminalClause);
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult getLuceneQuery(TerminalClause terminalClause) {
        Property property = (Property)terminalClause.getProperty().get();
        Iterable<IndexDocumentConfiguration.Type> propertyTypes = this.getPropertyTypes(property);
        Iterable<OperatorSpecificQueryFactory> queryFactories = this.getQueryFactories(propertyTypes);
        String fieldName = "ISSUEPROP_" + property.getAsPropertyString();
        return new GenericClauseQueryFactory(fieldName, (List)Lists.newArrayList(queryFactories), this.operandResolver).getQuery((QueryCreationContext)new QueryCreationContextImpl(this.authenticationContext.getUser()), terminalClause);
    }

    private Iterable<OperatorSpecificQueryFactory> getQueryFactories(Iterable<IndexDocumentConfiguration.Type> types) {
        return Iterables.concat((Iterable)Iterables.transform(types, (Function)new Function<IndexDocumentConfiguration.Type, Iterable<OperatorSpecificQueryFactory>>(){

            public Iterable<OperatorSpecificQueryFactory> apply(IndexDocumentConfiguration.Type type) {
                ImmutableList.Builder builder = ImmutableList.builder();
                switch (type) {
                    case NUMBER: {
                        NumberIndexValueConverter valueConverter = new NumberIndexValueConverter(IssuePropertyClauseQueryFactory.this.doubleConverter);
                        builder.add((Object)new ActualValueEqualityQueryFactory((IndexValueConverter)valueConverter));
                        builder.add((Object)new ActualValueRelationalQueryFactory((IndexValueConverter)valueConverter));
                        break;
                    }
                    case TEXT: {
                        builder.add((Object)new LikeQueryFactory());
                        break;
                    }
                    case DATE: {
                        builder.add((Object)new DateEqualityQueryFactory(IssuePropertyClauseQueryFactory.this.jqlDateSupport));
                        builder.add((Object)new DateRelationalQueryFactory(IssuePropertyClauseQueryFactory.this.jqlDateSupport));
                        break;
                    }
                    case STRING: {
                        builder.add((Object)new ActualValueEqualityQueryFactory((IndexValueConverter)new SimpleIndexValueConverter(false)));
                    }
                }
                return builder.build();
            }
        }));
    }

    private Iterable<IndexDocumentConfiguration.Type> getPropertyTypes(Property property) {
        Iterable<PluginIndexConfiguration> configurations = this.pluginIndexConfigurationManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        final String propertyKey = property.getKeysAsString();
        final String objRef = property.getObjectReferencesAsString();
        Iterable keyConfigurations = Iterables.concat((Iterable)Iterables.transform(configurations, (Function)new Function<PluginIndexConfiguration, List<IndexDocumentConfiguration.KeyConfiguration>>(){

            public List<IndexDocumentConfiguration.KeyConfiguration> apply(PluginIndexConfiguration indexConfiguration) {
                return indexConfiguration.getIndexDocumentConfiguration().getKeyConfigurations();
            }
        }));
        Iterable filteredConfigurations = Iterables.filter((Iterable)keyConfigurations, (Predicate)new Predicate<IndexDocumentConfiguration.KeyConfiguration>(){

            public boolean apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
                return keyConfiguration.getPropertyKey().equals(propertyKey);
            }
        });
        Iterable extractConfigurations = Iterables.concat((Iterable)Iterables.transform((Iterable)filteredConfigurations, (Function)new Function<IndexDocumentConfiguration.KeyConfiguration, List<IndexDocumentConfiguration.ExtractConfiguration>>(){

            public List<IndexDocumentConfiguration.ExtractConfiguration> apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
                return keyConfiguration.getExtractorConfigurations();
            }
        }));
        return Iterables.transform((Iterable)Iterables.filter((Iterable)extractConfigurations, (Predicate)new Predicate<IndexDocumentConfiguration.ExtractConfiguration>(){

            public boolean apply(IndexDocumentConfiguration.ExtractConfiguration extractConfig) {
                return extractConfig.getPath().equals(objRef);
            }
        }), (Function)new Function<IndexDocumentConfiguration.ExtractConfiguration, IndexDocumentConfiguration.Type>(){

            public IndexDocumentConfiguration.Type apply(IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
                return extractConfiguration.getType();
            }
        });
    }
}

