/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSet;

public class IssueIdCollector
extends Collector {
    private static final int SMALL_COLLECT_RATIO = 10000;
    final int maxDocs;
    private int docBase;
    final OpenBitSet docIds;
    private final IndexReader indexReader;
    private int hitcount = 0;

    public IssueIdCollector(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.maxDocs = indexReader.maxDoc();
        this.docIds = new OpenBitSet((long)this.maxDocs);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int doc) throws IOException {
        this.docIds.set((long)(this.docBase + doc));
        ++this.hitcount;
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public Set<String> getIssueIds() throws IOException {
        int smallDocLimit = Math.max(50, this.maxDocs / 10000);
        if (this.hitcount <= smallDocLimit) {
            return this.getIssueIdsDirectly();
        }
        return this.getIssueIdsByTerms();
    }

    public Set<String> getIssueIdsDirectly() throws IOException {
        HashSet<String> issueIds = new HashSet<String>(this.hitcount);
        FieldSelector selector = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                return fieldName.equals("issue_id") ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
        int docId = this.docIds.nextSetBit(0);
        while (docId >= 0) {
            Document doc = this.indexReader.document(docId, selector);
            issueIds.add(doc.get("issue_id"));
            docId = this.docIds.nextSetBit(docId + 1);
        }
        return issueIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIssueIdsByTerms() throws IOException {
        HashSet<String> issueIds = new HashSet<String>();
        TermDocs termDocs = this.indexReader.termDocs();
        TermEnum termEnum = this.indexReader.terms(new Term("issue_id", ""));
        try {
            Term term;
            while ((term = termEnum.term()) != null) {
                if (term.field() != "issue_id") {
                } else {
                    String issueId = term.text();
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        int doc = termDocs.doc();
                        if (!this.docIds.get(doc)) continue;
                        issueIds.add(issueId);
                        break;
                    }
                    if (termEnum.next()) continue;
                }
                break;
            }
        }
        finally {
            termDocs.close();
            termEnum.close();
        }
        return issueIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllIssueIds() throws IOException {
        HashSet<String> issueIds = new HashSet<String>();
        TermEnum termEnum = this.indexReader.terms(new Term("issue_id", ""));
        try {
            Term term;
            while ((term = termEnum.term()) != null) {
                if (term.field() != "issue_id") {
                } else {
                    String issueId = term.text();
                    issueIds.add(issueId);
                    if (termEnum.next()) continue;
                }
                break;
            }
        }
        finally {
            termEnum.close();
        }
        return issueIds;
    }
}

