/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

@NonInjectableComponent
public class IssueLiteralSanitiser
implements LiteralSanitiser {
    private final PermissionManager permissionManager;
    private final JqlIssueSupport jqlIssueSupport;
    private final User user;

    public IssueLiteralSanitiser(PermissionManager permissionManager, JqlIssueSupport jqlIssueSupport, User user) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.jqlIssueSupport = (JqlIssueSupport)Assertions.notNull((String)"jqlIssueSupport", (Object)jqlIssueSupport);
        this.user = user;
    }

    @Override
    public LiteralSanitiser.Result sanitiseLiterals(List<QueryLiteral> literals) {
        Assertions.notNull((String)"literals", literals);
        boolean isModified = false;
        LinkedHashSet<QueryLiteral> resultantLiterals = new LinkedHashSet<QueryLiteral>();
        for (QueryLiteral literal : literals) {
            List<Issue> issues = this.getIssues(literal);
            ArrayList<Long> badIds = new ArrayList<Long>();
            for (Issue issue : issues) {
                if (this.permissionManager.hasPermission(10, issue, this.user)) continue;
                badIds.add(issue.getId());
            }
            if (issues.size() == badIds.size() && !issues.isEmpty()) {
                for (Long badId : badIds) {
                    resultantLiterals.add(new QueryLiteral(literal.getSourceOperand(), badId));
                }
                isModified = true;
                continue;
            }
            resultantLiterals.add(literal);
        }
        return new LiteralSanitiser.Result(isModified, new ArrayList<QueryLiteral>(resultantLiterals));
    }

    List<Issue> getIssues(QueryLiteral literal) {
        Issue issue;
        if (literal.getStringValue() != null) {
            Issue issue2 = this.jqlIssueSupport.getIssue(literal.getStringValue());
            if (issue2 != null) {
                return Collections.singletonList(issue2);
            }
        } else if (literal.getLongValue() != null && (issue = this.jqlIssueSupport.getIssue(literal.getLongValue().longValue())) != null) {
            return Collections.singletonList(issue);
        }
        return Collections.emptyList();
    }
}

