/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Set;

@NonInjectableComponent
public class CustomFieldClausePermissionChecker
implements ClausePermissionChecker {
    private final FieldManager fieldManager;
    private final CustomField field;
    private final FieldConfigSchemeClauseContextUtil clauseContextUtil;

    public CustomFieldClausePermissionChecker(CustomField field, FieldManager fieldManager, FieldConfigSchemeClauseContextUtil clauseContextUtil) {
        this.clauseContextUtil = (FieldConfigSchemeClauseContextUtil)Assertions.notNull((String)"clauseContextUtil", (Object)clauseContextUtil);
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.field = (CustomField)Assertions.notNull((String)"field", (Object)field);
    }

    public boolean hasPermissionToUseClause(User user) {
        return this.hasPermissionToUseClause(user, this.fieldManager.getVisibleFieldLayouts(user));
    }

    public boolean hasPermissionToUseClause(User user, Set<FieldLayout> fieldLayouts) {
        if (!this.fieldManager.isFieldHidden(fieldLayouts, (Field)this.field)) {
            List fieldConfigSchemes = this.field.getConfigurationSchemes();
            for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
                ClauseContext context = this.clauseContextUtil.getContextForConfigScheme(user, fieldConfigScheme);
                if (context.getContexts().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static final class DefaultFactory
    implements Factory {
        @Override
        public ClausePermissionChecker createPermissionChecker(CustomField field, FieldConfigSchemeClauseContextUtil contextUtil) {
            return new CustomFieldClausePermissionChecker(field, DefaultFactory.getFieldManager(), contextUtil);
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(String fieldId, FieldConfigSchemeClauseContextUtil contextUtil) {
            CustomField field = DefaultFactory.getFieldManager().getCustomField(fieldId);
            return new CustomFieldClausePermissionChecker(field, DefaultFactory.getFieldManager(), contextUtil);
        }

        private static FieldManager getFieldManager() {
            return ComponentAccessor.getFieldManager();
        }
    }

    @InjectableComponent
    public static interface Factory {
        public ClausePermissionChecker createPermissionChecker(CustomField var1, FieldConfigSchemeClauseContextUtil var2);

        public ClausePermissionChecker createPermissionChecker(String var1, FieldConfigSchemeClauseContextUtil var2);
    }
}

