/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.parser;

import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.util.JqlStringSupportImpl;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import org.antlr.runtime.Token;
import org.apache.commons.lang.StringUtils;

public class JqlParseErrorMessages {
    private JqlParseErrorMessages() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Why are you trying to clone me?");
    }

    public static JqlParseErrorMessage reservedWord(String reservedWord, int antlrLine, int antlrColumn) {
        Assertions.notBlank((String)"reservedWord", (String)reservedWord);
        return JqlParseErrorMessages.createMessage("jql.parse.reserved.word", new Position(antlrLine, antlrColumn), JqlParseErrorMessages.normalizeString(reservedWord));
    }

    public static JqlParseErrorMessage illegalEsacpe(String illegalEscape, int antlrLine, int antlrColumn) {
        Position pos = new Position(antlrLine, antlrColumn);
        String normalizedString = JqlParseErrorMessages.normalizeString(illegalEscape);
        if (StringUtils.isBlank((String)illegalEscape)) {
            return JqlParseErrorMessages.createMessage("jql.parse.illegal.escape.blank", pos, new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.illegal.escape", pos, normalizedString);
    }

    public static JqlParseErrorMessage unfinishedString(String currentString, int antlrLine, int antlrColumn) {
        Position pos = new Position(antlrLine, antlrColumn);
        String normalizedString = JqlParseErrorMessages.normalizeString(currentString);
        if (StringUtils.isBlank((String)currentString)) {
            return JqlParseErrorMessages.createMessage("jql.parse.unfinished.string.blank", pos, new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.unfinished.string", pos, normalizedString);
    }

    public static JqlParseErrorMessage illegalCharacter(char currentChar, int antlrLine, int antlrColumn) {
        Position pos = new Position(antlrLine, antlrColumn);
        String escapeChar = JqlStringSupportImpl.encodeCharacterForce(currentChar);
        String printableChar = JqlParseErrorMessages.getPrintableCharacter(currentChar);
        return JqlParseErrorMessages.createMessage("jql.parse.illegal.character", pos, printableChar, escapeChar);
    }

    public static JqlParseErrorMessage reservedCharacter(char currentChar, int antlrLine, int antlrColumn) {
        Position pos = new Position(antlrLine, antlrColumn);
        String escapeChar = JqlStringSupportImpl.encodeCharacterForce(currentChar);
        String printableChar = JqlParseErrorMessages.getPrintableCharacter(currentChar);
        return JqlParseErrorMessages.createMessage("jql.parse.reserved.character", pos, printableChar, escapeChar);
    }

    public static JqlParseErrorMessage genericParseError() {
        return new JqlParseErrorMessage("jql.parse.unknown.no.pos", -1, -1, new Object[0]);
    }

    public static JqlParseErrorMessage genericParseError(int antlrLine, int antlrColumn) {
        Position pos = new Position(antlrLine, antlrColumn);
        return JqlParseErrorMessages.createMessage("jql.parse.unknown", pos, new Object[0]);
    }

    public static JqlParseErrorMessage genericParseError(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position position = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.unknown.no.pos", position.getLine(), position.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.unknown", position, new Object[0]);
    }

    public static JqlParseErrorMessage illegalNumber(String number, int antlrLine, int antlrColumn) {
        Assertions.notBlank((String)"number", (String)number);
        Position pos = new Position(antlrLine, antlrColumn);
        return JqlParseErrorMessages.createMessage("jql.parse.illegal.number", pos, JqlParseErrorMessages.normalizeString(number), Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static JqlParseErrorMessage emptyFieldName(int antlrLine, int antlrColumn) {
        return JqlParseErrorMessages.createMessage("jql.parse.empty.field", new Position(antlrLine, antlrColumn), new Object[0]);
    }

    public static JqlParseErrorMessage emptyFunctionName(int antlrLine, int antlrColumn) {
        return JqlParseErrorMessages.createMessage("jql.parse.empty.function", new Position(antlrLine, antlrColumn), new Object[0]);
    }

    public static JqlParseErrorMessage badFieldName(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.no.field.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        if (token.getType() == 29) {
            return JqlParseErrorMessages.createMessage("jql.parse.no.cf.field", pos, new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.no.field", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badSortOrder(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.no.order.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.no.order", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badOperator(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.no.operator.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.no.operator", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badPropertyArgument(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.bad.property.id.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.bad.property.id", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badCustomFieldId(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.bad.custom.field.id.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.bad.custom.field.id", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badFunctionArgument(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.bad.function.argument.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.bad.function.argument", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage needLogicalOperator(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.logical.operator.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.logical.operator", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage badOperand(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.bad.operand.eof", pos.getLine(), pos.getColumn(), new Object[0]);
        }
        return JqlParseErrorMessages.createMessage("jql.parse.bad.operand", pos, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage emptyFunctionArgument(Token token) {
        Assertions.notNull((String)"token", (Object)token);
        return JqlParseErrorMessages.createMessage("jql.parse.empty.function.argument", new Position(token), new Object[0]);
    }

    public static JqlParseErrorMessage expectedText(Token token, String expected) {
        Assertions.notNull((String)"token", (Object)token);
        Assertions.notBlank((String)"expected", (String)expected);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.expected.text.eof", pos.getLine(), pos.getColumn(), new Object[]{expected});
        }
        return JqlParseErrorMessages.createMessage("jql.parse.expected.text", pos, expected, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage expectedText(Token token, String expected1, String expected2) {
        Assertions.notNull((String)"token", (Object)token);
        Assertions.notBlank((String)"expected1", (String)expected1);
        Assertions.notBlank((String)"expected2", (String)expected2);
        Position pos = new Position(token);
        if (JqlParseErrorMessages.isEofToken(token)) {
            return new JqlParseErrorMessage("jql.parse.expected.text.2.eof", pos.getLine(), pos.getColumn(), new Object[]{expected1, expected2});
        }
        return JqlParseErrorMessages.createMessage("jql.parse.expected.text.2", pos, expected1, expected2, JqlParseErrorMessages.normalizeString(token.getText()));
    }

    public static JqlParseErrorMessage unsupportedPredicate(String predicate, String operator) {
        Assertions.notNull((String)"predicate", (Object)predicate);
        Assertions.notBlank((String)"operator", (String)operator);
        Position pos = new Position(0, 0);
        return JqlParseErrorMessages.createMessage("jql.parse.predicate.unsupported", pos, operator, predicate);
    }

    public static JqlParseErrorMessage unsupportedOperand(String operator, String operand) {
        Assertions.notNull((String)"operand", (Object)operand);
        Assertions.notBlank((String)"operator", (String)operator);
        Position pos = new Position(0, 0);
        return JqlParseErrorMessages.createMessage("jql.parse.operand.unsupported", pos, operator, operand);
    }

    private static JqlParseErrorMessage createMessage(String key, Position pos, Object ... args) {
        ArrayList<Object> arguments = new ArrayList<Object>(args.length + 2);
        arguments.add(pos.getLineString());
        arguments.add(pos.getColumnString());
        arguments.addAll(Arrays.asList(args));
        return new JqlParseErrorMessage(key, pos.getLine(), pos.getColumn(), arguments);
    }

    private static String normalizeString(String argument) {
        if (argument != null) {
            return argument.replace('\n', ' ').replace('\r', ' ');
        }
        return argument;
    }

    private static String getPrintableCharacter(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        if (JqlStringSupportImpl.isJqlControl(c) || Character.isWhitespace(c) || unicodeBlock == null || unicodeBlock == Character.UnicodeBlock.SPECIALS) {
            if (c == '\t') {
                return String.format("TAB", new Object[0]);
            }
            return String.format("U+%04X", c);
        }
        return String.valueOf(c);
    }

    private static boolean isEofToken(Token token) {
        return token.getType() == -1;
    }

    private static class Position {
        private int line;
        private int column;

        private Position(Token token) {
            this(token.getLine(), token.getCharPositionInLine());
        }

        private Position(int line, int column) {
            this.line = Position.normalizeLine(line);
            this.column = Position.normalizeColumn(column);
        }

        private static int normalizeLine(int line) {
            return line <= 0 ? -1 : line;
        }

        private static int normalizeColumn(int column) {
            return column < 0 ? -1 : column + 1;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getLineString() {
            if (this.line < 0) {
                return "?";
            }
            return String.valueOf(this.line);
        }

        public String getColumnString() {
            if (this.line < 0 || this.column < 0) {
                return "?";
            }
            return String.valueOf(this.column);
        }
    }
}

