/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand.registry;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunctionModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;

@ThreadSafe
class LazyResettableJqlFunctionHandlerRegistry
implements JqlFunctionHandlerRegistry {
    private static final Logger log = Logger.getLogger(LazyResettableJqlFunctionHandlerRegistry.class);
    private final PluginAccessor pluginAccesor;
    private final ModuleDescriptors.Orderings moduleDescriptorOrderings;
    @ClusterSafe
    private final ResettableLazyReference<Map<String, FunctionOperandHandler>> registryRef = new ResettableLazyReference<Map<String, FunctionOperandHandler>>(){

        protected Map<String, FunctionOperandHandler> create() throws Exception {
            return LazyResettableJqlFunctionHandlerRegistry.this.loadFromJqlFunctionModuleDescriptors();
        }
    };

    LazyResettableJqlFunctionHandlerRegistry(PluginAccessor pluginAccesor, ModuleDescriptors.Orderings moduleDescriptorOrderings) {
        this.pluginAccesor = pluginAccesor;
        this.moduleDescriptorOrderings = moduleDescriptorOrderings;
    }

    Map<String, FunctionOperandHandler> loadFromJqlFunctionModuleDescriptors() {
        List jqlFunctionModuleDescriptors = this.pluginAccesor.getEnabledModuleDescriptorsByClass(JqlFunctionModuleDescriptor.class);
        List sortedJqlModuleDescriptors = this.moduleDescriptorOrderings.byOrigin().compound(this.moduleDescriptorOrderings.natural()).sortedCopy((Iterable)jqlFunctionModuleDescriptors);
        ConcurrentHashMap<String, FunctionOperandHandler> registry = new ConcurrentHashMap<String, FunctionOperandHandler>();
        for (JqlFunctionModuleDescriptor descriptor : sortedJqlModuleDescriptors) {
            FunctionOperandHandler operandHandler;
            JqlFunction jqlFunction = (JqlFunction)descriptor.getModule();
            String functionName = CaseFolding.foldString((String)jqlFunction.getFunctionName());
            OperandHandler handler = registry.putIfAbsent(functionName, operandHandler = new FunctionOperandHandler(jqlFunction));
            if (handler == null) continue;
            log.error((Object)String.format("Plugin '%s' defined a function with the name: '%s' but one with that name already exists.", descriptor.getPlugin().getName(), functionName));
        }
        return registry;
    }

    void reset() {
        this.registryRef.reset();
    }

    @Override
    public FunctionOperandHandler getOperandHandler(FunctionOperand operand) {
        Assertions.notNull((String)"operand", (Object)operand);
        Map registry = (Map)this.registryRef.get();
        FunctionOperandHandler handler = (FunctionOperandHandler)registry.get(CaseFolding.foldString((String)operand.getName()));
        if (handler == null && log.isDebugEnabled()) {
            log.debug((Object)("Unable to find handler for function '" + operand.getName() + "'."));
        }
        return handler;
    }

    @Override
    public List<String> getAllFunctionNames() {
        ArrayList<String> functionNames = new ArrayList<String>();
        for (FunctionOperandHandler functionOperandHandler : ((Map)this.registryRef.get()).values()) {
            functionNames.add(functionOperandHandler.getJqlFunction().getFunctionName());
        }
        Collections.sort(functionNames);
        return functionNames;
    }
}

