/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.PredicateOperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PredicateOperandHandlerRegistry {
    private static final Logger log = Logger.getLogger(PredicateOperandHandlerRegistry.class);
    private final JqlFunctionHandlerRegistry functionRegistry;
    private final ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager;

    public PredicateOperandHandlerRegistry(JqlFunctionHandlerRegistry functionRegistry, ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager) {
        this.changeHistoryFieldConfigurationManager = changeHistoryFieldConfigurationManager;
        this.functionRegistry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"functionRegistry", (Object)functionRegistry);
    }

    public PredicateOperandHandler getHandler(User searcher, String field, Operand operand) {
        if (operand instanceof SingleValueOperand) {
            return new SingleValuePredicateOperandHandler(searcher, (SingleValueOperand)operand);
        }
        if (operand instanceof EmptyOperand) {
            return new EmptyPredicateOperandHandler(this.changeHistoryFieldConfigurationManager, searcher, field, (EmptyOperand)operand);
        }
        if (operand instanceof MultiValueOperand) {
            return new MultiValuePredicateOperandHandler(searcher, this, field, (MultiValueOperand)operand);
        }
        if (operand instanceof FunctionOperand) {
            return new FunctionPredicateOperandHandler(searcher, (FunctionOperand)operand, this.functionRegistry);
        }
        log.debug((Object)String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        return null;
    }

    static final class FunctionPredicateOperandHandler
    implements PredicateOperandHandler {
        private final FunctionOperand operand;
        private final ApplicationUser searcher;
        private final JqlFunctionHandlerRegistry functionRegistry;

        FunctionPredicateOperandHandler(User searcher, FunctionOperand operand, JqlFunctionHandlerRegistry functionRegistry) {
            this.searcher = ApplicationUsers.from((User)searcher);
            this.operand = operand;
            this.functionRegistry = functionRegistry;
        }

        @Override
        public List<QueryLiteral> getValues() {
            FunctionOperandHandler handler = this.functionRegistry.getOperandHandler(this.operand);
            return handler != null ? handler.getValues((QueryCreationContext)new QueryCreationContextImpl(this.searcher), this.operand, (TerminalClause)new TerminalClauseImpl("PredicateOperandClause", Operator.EQUALS, (Operand)this.operand)) : Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return true;
        }
    }

    static final class MultiValuePredicateOperandHandler
    implements PredicateOperandHandler {
        private final PredicateOperandHandlerRegistry handlerRegistry;
        private final MultiValueOperand operand;
        private final String field;
        private final User searcher;

        MultiValuePredicateOperandHandler(User searcher, PredicateOperandHandlerRegistry handlerRegistry, String field, MultiValueOperand operand) {
            this.searcher = searcher;
            this.handlerRegistry = handlerRegistry;
            this.field = field;
            this.operand = operand;
        }

        @Override
        public List<QueryLiteral> getValues() {
            ArrayList<QueryLiteral> valuesList = new ArrayList<QueryLiteral>();
            for (Operand subOperand : this.operand.getValues()) {
                List<QueryLiteral> vals = this.handlerRegistry.getHandler(this.searcher, this.field, subOperand).getValues();
                if (vals == null) continue;
                valuesList.addAll(vals);
            }
            return valuesList;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    static final class EmptyPredicateOperandHandler
    implements PredicateOperandHandler {
        private final EmptyOperand emptyOperand;
        private final User searcher;
        private final String field;
        private final ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager;

        EmptyPredicateOperandHandler(ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager, User searcher, String field, EmptyOperand emptyOperand) {
            this.changeHistoryFieldConfigurationManager = changeHistoryFieldConfigurationManager;
            this.searcher = searcher;
            this.field = field;
            this.emptyOperand = emptyOperand;
        }

        @Override
        public List<QueryLiteral> getValues() {
            ArrayList literals = Lists.newArrayList();
            if (this.emptyOperand != null) {
                literals.add(new QueryLiteral((Operand)this.emptyOperand, this.getStringValueForEmpty(this.field)));
            }
            return literals;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }

        private String getStringValueForEmpty(String field) {
            return field != null ? this.changeHistoryFieldConfigurationManager.getEmptyValue(field.toLowerCase()) : null;
        }
    }

    static final class SingleValuePredicateOperandHandler
    implements PredicateOperandHandler {
        private final SingleValueOperand singleValueOperand;
        private final User searcher;

        SingleValuePredicateOperandHandler(User searcher, SingleValueOperand singleValueOperand) {
            this.singleValueOperand = singleValueOperand;
            this.searcher = searcher;
        }

        @Override
        public List<QueryLiteral> getValues() {
            if (this.singleValueOperand.getLongValue() == null) {
                return Collections.singletonList(new QueryLiteral((Operand)this.singleValueOperand, this.singleValueOperand.getStringValue()));
            }
            return Collections.singletonList(new QueryLiteral((Operand)this.singleValueOperand, this.singleValueOperand.getLongValue()));
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }
}

