/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.util.JellyTagUtils;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;

public class AttachFile
extends JiraDynaBeanTagSupport {
    private static final Logger log = Logger.getLogger(AttachFile.class);
    public static final String OPTION_SKIP = "skip";
    public static final String OPTION_OVERRIDE = "override";
    public static final String OPTION_ADD = "add";
    private static final List<String> availableOptions = ImmutableList.of((Object)"skip", (Object)"override", (Object)"add");
    private static final String KEY_ISSUE_KEY = "key";
    private static final String KEY_FILEPATH = "filepath";
    private static final String KEY_OPTION = "option";
    private static final String KEY_CREATED_DATE = "created";
    private final AttachmentManager attachmentManager = ComponentAccessor.getAttachmentManager();
    private static final FastDateFormat TMP_FOLDER_FORMATTER = FastDateFormat.getInstance((String)"yyyyMMddhhmmssSSS");

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        block21: {
            String issueKey = this.getKey();
            String filepath = this.getFilepath();
            String option = this.getOption();
            String created = this.getCreated();
            Timestamp createdDate = TextUtils.stringSet((String)created) ? JellyTagUtils.parseDate(created) : null;
            String username = (String)this.getContext().getVariable("jelly.username");
            User user = null;
            if (!TextUtils.stringSet((String)issueKey)) {
                throw new MissingAttributeException(KEY_ISSUE_KEY);
            }
            if (!TextUtils.stringSet((String)filepath)) {
                throw new MissingAttributeException(KEY_FILEPATH);
            }
            File originalFile = new File(this.getFilepath());
            JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
            String FS = jiraSystemProperties.getProperty("file.separator");
            String TMP_DIR = jiraSystemProperties.getProperty("java.io.tmpdir");
            String TMP_DIR_NAME = TMP_FOLDER_FORMATTER.format(new Date());
            File tmpFile = new File(TMP_DIR + FS + TMP_DIR_NAME + FS + originalFile.getName());
            try {
                FileUtils.copyFile((File)originalFile, (File)tmpFile);
            }
            catch (IOException e) {
                log.warn((Object)"Unable to make temporary copy of file.", (Throwable)e);
                throw new JellyTagException("Unable to make temporary copy of file.", (Throwable)e);
            }
            if (username != null && (user = UserUtils.getUser((String)username)) == null) {
                throw new JellyTagException("The user '" + username + "' cannot be found.");
            }
            if (!TextUtils.stringSet((String)option)) {
                option = OPTION_ADD;
            }
            try {
                MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(issueKey);
                if (issue != null) {
                    if (OPTION_ADD.equals(option)) {
                        this.attachFile(tmpFile, user, (Issue)issue, createdDate);
                    } else if (OPTION_OVERRIDE.equals(option)) {
                        Long attachmentId = this.getAttachmentId((Issue)issue, tmpFile.getName());
                        if (attachmentId != null) {
                            try {
                                log.debug((Object)("Found existing attachment with filename '" + tmpFile.getName() + "'. Removing it to import the new attachment."));
                                this.attachmentManager.deleteAttachment(this.attachmentManager.getAttachment(attachmentId));
                            }
                            catch (Exception e) {
                                throw new JellyTagException("Error occured while removing attachment.", (Throwable)e);
                            }
                        }
                        this.attachFile(tmpFile, user, (Issue)issue, createdDate);
                    } else if (OPTION_SKIP.equals(option)) {
                        if (this.getAttachmentId((Issue)issue, tmpFile.getName()) != null) {
                            log.debug((Object)("Found existing attachment with filename '" + tmpFile.getName() + "'. Will not import the new attachment."));
                        } else {
                            this.attachFile(tmpFile, user, (Issue)issue, createdDate);
                        }
                    } else {
                        throw new JellyTagException("Invalid value for the 'option' attribute. Must be one of the following: " + availableOptions);
                    }
                    if (tmpFile.getParentFile().isDirectory() && tmpFile.getParentFile().getName().equals(TMP_DIR_NAME)) {
                        tmpFile.getParentFile().delete();
                    }
                    break block21;
                }
                log.warn((Object)("Unable to find an issue with key '" + issueKey + "' not adding the attachment."));
                throw new JellyTagException("Unable to find an issue with key '" + issueKey + "' not adding the attachment.");
            }
            catch (GenericEntityException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void attachFile(File file, User user, Issue issue, Timestamp createdDate) throws GenericEntityException, JellyTagException {
        try {
            if (createdDate == null) {
                this.attachmentManager.createAttachment(file, file.getName(), "application/octet-stream", user, issue);
            } else {
                this.attachmentManager.createAttachment(file, file.getName(), "application/octet-stream", user, issue, Collections.EMPTY_MAP, (Date)createdDate);
            }
        }
        catch (AttachmentException e) {
            throw new JellyTagException("Error occured while attaching file.", (Throwable)e);
        }
    }

    public String[] getRequiredProperties() {
        return new String[]{KEY_ISSUE_KEY, KEY_FILEPATH};
    }

    private Long getAttachmentId(Issue issue, String compareFilename) {
        List attachments = this.attachmentManager.getAttachments(issue);
        for (Attachment attachment : attachments) {
            String filename = attachment.getFilename();
            if (!filename.equals(compareFilename)) continue;
            return attachment.getId();
        }
        return null;
    }

    public String getKey() {
        return (String)this.getProperties().get(KEY_ISSUE_KEY);
    }

    public String getFilepath() {
        return (String)this.getProperties().get(KEY_FILEPATH);
    }

    public String getOption() {
        return (String)this.getProperties().get(KEY_OPTION);
    }

    public String getCreated() {
        return (String)this.getProperties().get(KEY_CREATED_DATE);
    }

    public File getTempDirName(String name) {
        JiraProperties jiraSystemProperties = JiraSystemProperties.getInstance();
        String FS = jiraSystemProperties.getProperty("file.separator");
        String TMP_DIR = jiraSystemProperties.getProperty("java.io.tmpdir");
        String TMP_DIR_NAME = TMP_FOLDER_FORMATTER.format(new Date());
        return new File(TMP_DIR + FS + TMP_DIR_NAME + FS + name);
    }
}

