/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jelly.tag.issue.CustomFieldValuesAwareTag;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;

public class AddCustomFieldValue
extends TagSupport {
    private String id;
    private String name;
    private String value;
    private String key;

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        CustomField customField;
        CustomFieldValuesAwareTag customFieldValuesAwareTag;
        this.validate();
        CustomFieldValuesAwareTag parent = this.findCustomFieldValuesAwareTag((Tag)this);
        if (parent != null) {
            customFieldValuesAwareTag = parent;
            customField = null;
            if (StringUtils.isNotEmpty((String)this.getId())) {
                customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(this.getId());
            } else if (StringUtils.isNotEmpty((String)this.getName())) {
                customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObjectByName(this.getName());
            }
            if (customField == null) {
                throw new JellyTagException("Custom Field id/name is not valid");
            }
        } else {
            throw new JellyTagException("AddCustomFieldValue must be inside a CreateIssue or a TransitionWorkflow tag");
        }
        customFieldValuesAwareTag.addCustomFieldValue(customField, this.getValue(), this.getKey());
    }

    private void validate() throws MissingAttributeException {
        if (StringUtils.isEmpty((String)this.getValue())) {
            throw new MissingAttributeException("value");
        }
        if (StringUtils.isEmpty((String)this.getId()) && StringUtils.isEmpty((String)this.getName())) {
            throw new MissingAttributeException("id or name");
        }
    }

    private CustomFieldValuesAwareTag findCustomFieldValuesAwareTag(Tag tag) {
        if (tag == null || tag instanceof CustomFieldValuesAwareTag) {
            return (CustomFieldValuesAwareTag)tag;
        }
        return this.findCustomFieldValuesAwareTag(tag.getParent());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

