/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.jelly.IssueContextAccessor;
import com.atlassian.jira.jelly.IssueContextAccessorImpl;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.WebWorkAdaptor;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import com.atlassian.jira.jelly.tag.issue.CustomFieldValuesAwareTag;
import com.atlassian.jira.jelly.tag.util.JellyTagUtils;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.util.UserManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.xml.sax.SAXException;

public abstract class AbstractCreateIssue
extends ProjectAwareActionTagSupport
implements ProjectContextAccessor,
IssueContextAccessor,
CustomFieldValuesAwareTag {
    private static final Logger log = Logger.getLogger(AbstractCreateIssue.class);
    protected static final String KEY_ISSUE_ID = "key";
    protected static final String KEY_PROJECT_ID = "pid";
    protected static final String KEY_ISSUE_ASSIGNEE = "assignee";
    protected static final String KEY_ISSUE_CREATED_DATE = "created";
    protected static final String KEY_ISSUE_UPDATED_DATE = "updated";
    protected static final String KEY_ISSUE_TYPE = "issueType";
    protected static final String KEY_PRIORITY = "priority";
    protected static final String KEY_ISSUE_REPORTER = "reporter";
    protected static final String KEY_SUMMARY = "summary";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_ENVIRONMENT = "environment";
    protected static final String KEY_COMPONENTS = "components";
    protected static final String KEY_VERSIONS = "versions";
    protected static final String KEY_FIX_VERSIONS = "fixVersions";
    protected static final String KEY_ISSUE_SECURITY = "security";
    protected static final String KEY_DUPLICATE_SUMMARY = "duplicateSummary";
    protected static final String KEY_ISSUE_ID_VAR = "issueIdVar";
    protected static final String KEY_ISSUE_KEY_VAR = "issueKeyVar";
    protected static final String KEY_ISSUE_ASSIGNEE_VAR = "issueAssigneeVar";
    private Map issueTypeMap = null;
    private Map priorityMap = null;
    private final ProjectContextAccessor projectContextAccessor;
    private final IssueContextAccessor issueContextAccessor;
    private boolean hasPreviousUsername = false;
    private String previousUsername = null;
    private boolean hasPreviousIssueSchemeLevelId = false;
    private Long previousIssueSchemeLevelId = null;
    private static final String DUPLICATE_SUMMARY_IGNORE = "ignore";
    private final VersionManager versionManager;
    private UserManager userManager;

    public AbstractCreateIssue(VersionManager versionManager, UserManager userManager) {
        this.userManager = userManager;
        this.setExecuteWebworkOnClose(true);
        this.setActionName("CreateIssueDetails");
        this.issueContextAccessor = new IssueContextAccessorImpl((Tag)this);
        this.projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
        this.versionManager = versionManager;
    }

    @Override
    protected void preContextValidation() {
        if (this.getProperties().containsKey(KEY_ISSUE_REPORTER)) {
            this.setPreviousUsername(this.getUsername());
            String reporterUsername = this.getProperty(KEY_ISSUE_REPORTER.toLowerCase());
            this.getContext().setVariable("jelly.username", (Object)reporterUsername);
            this.setLoggedinUser(reporterUsername);
        }
        String PROJECT_KEY = "project-key";
        if (this.getProperties().containsKey("project-key")) {
            this.setProject(this.getProperty("project-key"));
        }
    }

    private void setLoggedinUser(String reporterUsername) {
        User reporter = this.userManager.getUser(reporterUsername);
        ComponentAccessor.getJiraAuthenticationContext().setLoggedInUser(reporter);
    }

    protected boolean isDuplicateIssue(XMLOutput output) throws SAXException {
        List matchingIssues;
        log.debug((Object)"CreateIssue.isDuplicateIssue");
        String duplicateSummary = this.getProperty(KEY_DUPLICATE_SUMMARY);
        if (!DUPLICATE_SUMMARY_IGNORE.equals(duplicateSummary) && !(matchingIssues = ComponentAccessor.getOfBizDelegator().findByAnd("Issue", EasyMap.build((Object)"project", (Object)this.getProjectId(), (Object)KEY_SUMMARY, (Object)this.getProperty(KEY_SUMMARY)))).isEmpty()) {
            String errorMsg = "Duplicate Issue : Another issue for this project with the same values for \"summary\"";
            WebWorkAdaptor.writeErrorToXmlOutput(output, new StringBuffer(errorMsg), this.getActionName(), (TagSupport)this);
            return true;
        }
        return false;
    }

    public boolean hasIssueScheme() {
        return this.getContext().getVariables().containsKey("jelly.issue.scheme.id");
    }

    public Long getIssueSchemeId() {
        throw new UnsupportedOperationException();
    }

    public GenericValue getIssueScheme() {
        throw new UnsupportedOperationException();
    }

    protected String getPreviousUsername() {
        return this.previousUsername;
    }

    private void setPreviousUsername(String previousUsername) {
        this.hasPreviousUsername = true;
        this.previousUsername = previousUsername;
    }

    protected Long getPreviousIssueSchemeLevelId() {
        return this.previousIssueSchemeLevelId;
    }

    protected void setPreviousIssueSchemeLevelId(Long previousIssueSchemeLevelId) {
        this.hasPreviousIssueSchemeLevelId = true;
        this.previousIssueSchemeLevelId = previousIssueSchemeLevelId;
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }

    @Override
    public void setIssue(Long issueId) {
        this.issueContextAccessor.setIssue(issueId);
    }

    @Override
    public void setIssue(String issueKey) {
        this.issueContextAccessor.setIssue(issueKey);
    }

    @Override
    public void setIssue(GenericValue issue) {
        this.issueContextAccessor.setIssue(issue);
    }

    @Override
    public void loadPreviousIssue() {
        this.issueContextAccessor.loadPreviousIssue();
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        String assignee;
        if (this.hasProject()) {
            this.setProperty(KEY_PROJECT_ID, this.getProjectId().toString());
        }
        try {
            this.mapProperty(KEY_ISSUE_TYPE, "issuetype", this.getIssueTypes(), "Issue Type", output);
            this.mapProperty(KEY_PRIORITY, this.getPriorities(), "Priority", output);
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
        if (this.getProperty("issuetype") == null && !this.getIssueTypes().isEmpty()) {
            this.setProperty("issuetype", (String)this.getIssueTypes().keySet().iterator().next());
        }
        if (this.getProperty(KEY_PRIORITY) == null && !this.getPriorities().isEmpty()) {
            this.setProperty(KEY_PRIORITY, (String)this.getPriorities().keySet().iterator().next());
        }
        if ((assignee = this.getProperty(KEY_ISSUE_ASSIGNEE)) != null) {
            this.setProperty(KEY_ISSUE_ASSIGNEE, assignee.toLowerCase());
        }
        try {
            this.convertComponentNameToId();
            this.convertVersionNameToId();
        }
        catch (GenericEntityException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    private void convertVersionNameToId() throws GenericEntityException {
        log.debug((Object)"CreateIssue.convertVersionNameToId");
        GenericValue project = ManagerFactory.getProjectManager().getProject(Long.valueOf(this.getProperty(KEY_PROJECT_ID)));
        this.convertVersionNameToId(KEY_VERSIONS, project);
        this.convertVersionNameToId(KEY_FIX_VERSIONS, project);
    }

    private void convertVersionNameToId(String key, GenericValue project) {
        String versionNames = this.getProperty(key);
        if (StringUtils.isNotEmpty((String)versionNames)) {
            StringTokenizer tokenizer = new StringTokenizer(versionNames, ",");
            ArrayList<String> versions = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String versionName = tokenizer.nextToken().trim();
                Version version = this.versionManager.getVersion(project.getLong("id"), versionName);
                if (version != null) {
                    versions.add(version.getString("id"));
                    continue;
                }
                log.warn((Object)(key + " \"" + versionName + "\" unknown : " + this.toString()));
            }
            if (versions.size() > 0) {
                this.getProperties().put(key, versions.toArray(new String[versions.size()]));
            }
        }
    }

    private void convertComponentNameToId() {
        log.debug((Object)"CreateIssue.convertComponentNameToId");
        String componentNames = this.getProperty(KEY_COMPONENTS);
        if (StringUtils.isNotEmpty((String)componentNames)) {
            ProjectManager projectManager = ManagerFactory.getProjectManager();
            GenericValue project = this.getProject();
            StringTokenizer tokenizer = new StringTokenizer(componentNames, ",");
            ArrayList<String> components = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String componentName = tokenizer.nextToken().trim();
                GenericValue component = projectManager.getComponent(project, componentName);
                if (component != null) {
                    components.add(component.get("id").toString());
                    continue;
                }
                log.warn((Object)("Component \"" + componentName + "\" unknown : " + this.toString()));
            }
            if (components.size() > 0) {
                this.getProperties().put(KEY_COMPONENTS, components.toArray(new String[components.size()]));
            }
        }
    }

    public Map getIssueTypes() {
        if (this.issueTypeMap == null) {
            this.issueTypeMap = new HashMap();
            Collection issueTypes = ManagerFactory.getConstantsManager().getIssueTypes();
            for (GenericValue issueType : issueTypes) {
                this.issueTypeMap.put(issueType.getString("id"), issueType.getString("name"));
            }
        }
        return Collections.unmodifiableMap(this.issueTypeMap);
    }

    public Map getPriorities() {
        if (this.priorityMap == null) {
            this.priorityMap = new HashMap();
            Collection priorities = ManagerFactory.getConstantsManager().getPriorities();
            for (GenericValue priority : priorities) {
                this.priorityMap.put(priority.getString("id"), priority.getString("name"));
            }
        }
        return Collections.unmodifiableMap(this.priorityMap);
    }

    @Override
    protected boolean propertyValidation(XMLOutput output) throws JellyTagException {
        try {
            if (!super.propertyValidation(output) || this.isDuplicateIssue(output)) {
                return false;
            }
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postTagExecution(XMLOutput output) throws JellyTagException {
        block12: {
            try {
                log.debug((Object)"CreateIssue.postTagExecution");
                this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
                if (!this.getProperties().containsKey(KEY_ISSUE_ID)) break block12;
                String key = this.getProperty(KEY_ISSUE_ID);
                this.setIssue(key);
                if (this.getProperties().containsKey(KEY_ISSUE_KEY_VAR)) {
                    this.getContext().setVariable(this.getProperty(KEY_ISSUE_KEY_VAR), (Object)key);
                }
                GenericValue issue = null;
                try {
                    boolean shouldStore;
                    issue = ComponentAccessor.getIssueManager().getIssue(key);
                    if (this.getProperties().containsKey(KEY_ISSUE_ID_VAR) || this.getProperties().containsKey(KEY_ISSUE_ASSIGNEE_VAR)) {
                        if (this.getProperties().containsKey(KEY_ISSUE_ID_VAR)) {
                            this.getContext().setVariable(this.getProperty(KEY_ISSUE_ID_VAR), (Object)issue.getLong("id").toString());
                        }
                        if (this.getProperties().containsKey(KEY_ISSUE_ASSIGNEE_VAR)) {
                            this.getContext().setVariable(this.getProperty(KEY_ISSUE_ASSIGNEE_VAR), (Object)issue.getString(KEY_ISSUE_ASSIGNEE));
                        }
                    }
                    if (shouldStore = this.modifyCreationDate(issue) | this.modifyUpdateDate(issue)) {
                        issue.store();
                        ComponentAccessor.getIssueIndexManager().reIndex(issue);
                    }
                }
                catch (GenericEntityException e) {
                    throw new JellyTagException((Throwable)e);
                }
                catch (IndexException e) {
                    log.error((Object)("Error while re-indexing issue '" + issue.getString(KEY_ISSUE_ID) + "'. Seraching results may give incorrect results"));
                }
            }
            finally {
                if (this.hasPreviousUsername) {
                    this.setLoggedinUser(this.previousUsername);
                }
            }
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        if (this.hasPreviousUsername) {
            this.getContext().setVariable("jelly.username", (Object)this.getPreviousUsername());
        }
        if (this.hasPreviousIssueSchemeLevelId) {
            this.getContext().setVariable("jelly.issue.scheme.level.id", (Object)this.getPreviousIssueSchemeLevelId());
        }
        this.loadPreviousProject();
        this.loadPreviousIssue();
    }

    private boolean modifyCreationDate(GenericValue issue) {
        log.debug((Object)"CreateIssue.modifyCreationDate");
        String creationDate = this.getProperty(KEY_ISSUE_CREATED_DATE);
        if (creationDate != null) {
            Timestamp created = JellyTagUtils.parseDate(creationDate);
            issue.set(KEY_ISSUE_CREATED_DATE, (Object)created);
            return true;
        }
        log.debug((Object)"Creation date not set, using todays date");
        return false;
    }

    private boolean modifyUpdateDate(GenericValue issue) {
        log.debug((Object)"CreateIssue.modifyUpdateDate");
        String updatedDate = this.getProperty(KEY_ISSUE_UPDATED_DATE);
        if (updatedDate != null) {
            Timestamp updated = JellyTagUtils.parseDate(updatedDate);
            issue.set(KEY_ISSUE_UPDATED_DATE, (Object)updated);
            return true;
        }
        log.debug((Object)"Update date not set, using todays date");
        return false;
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_PROJECT_ID, "issuetype", KEY_SUMMARY};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[]{"jelly.issue.id", "jelly.issue.key"};
    }

    @Override
    public void addCustomFieldValue(CustomField customField, String customFieldValue, String key) {
        String customFieldId = customField.getId();
        if (key != null) {
            this.setProperty(customFieldId + ":" + key, customFieldValue);
        } else if (this.propertyContains(customFieldId)) {
            this.setProperty(customFieldId + ":" + String.valueOf(this.getProperties().size()), customFieldValue);
        } else {
            this.setProperty(customFieldId, customFieldValue);
        }
    }
}

