/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.jira.jelly.tag.UserAwareActionTagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;

public class CreatePermissionScheme
extends UserAwareActionTagSupport {
    private static final Logger log = Logger.getLogger(CreatePermissionScheme.class);
    private static final String KEY_SCHEMENAME = "name";
    private static final String KEY_SCHEMEID = "schemeId";
    private boolean hasPreviousPermissionSchemeId = false;
    private Long previousPermissionSchemeId = null;

    public CreatePermissionScheme() {
        this.setActionName("AddPermissionScheme");
    }

    @Override
    protected void postTagExecution(XMLOutput output) {
        log.debug((Object)"CreatePermissionScheme.postTagExecution");
        this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
        try {
            this.setPreviousPermissionSchemeId((Long)this.getContext().getVariable("jelly.permission.scheme.id"));
            this.getContext().setVariable("jelly.permission.scheme.id", (Object)new Long(this.getProperty(KEY_SCHEMEID)));
        }
        catch (NumberFormatException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        if (this.hasPreviousPermissionSchemeId) {
            this.getContext().setVariable("jelly.permission.scheme.id", (Object)this.getPreviousPermissionSchemeId());
        }
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_SCHEMENAME};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[]{"jelly.permission.scheme.id"};
    }

    public Long getPreviousPermissionSchemeId() {
        return this.previousPermissionSchemeId;
    }

    public void setPreviousPermissionSchemeId(Long previousPermissionSchemeId) {
        this.hasPreviousPermissionSchemeId = true;
        this.previousPermissionSchemeId = previousPermissionSchemeId;
    }
}

