/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.GroupAware;
import com.atlassian.jira.jelly.GroupContextAccessor;
import com.atlassian.jira.jelly.GroupContextAccessorImpl;
import com.atlassian.jira.jelly.NewUserAware;
import com.atlassian.jira.jelly.NewUserContextAccessor;
import com.atlassian.jira.jelly.NewUserContextAccessorImpl;
import com.atlassian.jira.jelly.tag.UserAwareActionTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;

public class AddUserToGroup
extends UserAwareActionTagSupport
implements NewUserAware,
GroupAware,
NewUserContextAccessor,
GroupContextAccessor {
    private static final String KEY_USERNAME = "name";
    private static final String KEY_GROUPS_TO_JOIN = "groupsToJoin";
    private static final String KEY_JOIN = "join";
    private NewUserContextAccessor newUserContextAccessor = new NewUserContextAccessorImpl((Tag)this);
    private GroupContextAccessor groupContextAccessor = new GroupContextAccessorImpl((Tag)this);

    public AddUserToGroup() {
        this.setActionName("EditUserGroups");
    }

    @Override
    protected void preContextValidation() {
        String NEW_USERNAME = "username";
        if (this.getProperties().containsKey("username")) {
            this.setNewUser(this.getProperty("username"));
        }
        String GROUP_NAME = "group-name";
        if (this.getProperties().containsKey("group-name")) {
            this.setGroup(this.getProperty("group-name"));
        }
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (this.hasNewUsername()) {
            this.setProperty(KEY_USERNAME, this.getNewUsername());
        }
        if (this.hasGroup()) {
            this.setProperty(KEY_GROUPS_TO_JOIN, this.getGroupName());
        }
        this.setProperty(KEY_JOIN, "true");
    }

    @Override
    public String[] getRequiredContextVariables() {
        String[] requiredContextVariables = super.getRequiredContextVariables();
        String[] required = new String[requiredContextVariables.length + 2];
        System.arraycopy(requiredContextVariables, 0, required, 0, requiredContextVariables.length);
        required[required.length - 2] = "jelly.new.username";
        required[required.length - 1] = "jelly.group.name";
        return required;
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousNewUser();
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{KEY_USERNAME, KEY_GROUPS_TO_JOIN};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public boolean hasGroup() {
        return this.getContext().getVariables().containsKey("jelly.group.name");
    }

    @Override
    public String getGroupName() {
        if (this.hasGroup()) {
            return (String)this.getContext().getVariable("jelly.group.name");
        }
        return null;
    }

    @Override
    public Group getGroup() {
        return ComponentAccessor.getGroupManager().getGroup(this.getGroupName());
    }

    @Override
    public boolean hasNewUsername() {
        return this.getContext().getVariables().containsKey("jelly.new.username");
    }

    @Override
    public String getNewUsername() {
        return (String)this.getContext().getVariable("jelly.new.username");
    }

    @Override
    public void setNewUser(String username) {
        this.newUserContextAccessor.setNewUser(username);
    }

    @Override
    public void setNewUser(User user) {
        this.newUserContextAccessor.setNewUser(user);
    }

    @Override
    public void loadPreviousNewUser() {
        this.newUserContextAccessor.loadPreviousNewUser();
    }

    @Override
    public void setGroup(String groupname) {
        this.groupContextAccessor.setGroup(groupname);
    }

    @Override
    public void setGroup(Group group) {
        this.groupContextAccessor.setGroup(group);
    }

    @Override
    public void loadPreviousGroup() {
        this.groupContextAccessor.loadPreviousGroup();
    }
}

