/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.transport.impl.ActionParamsImpl;
import com.atlassian.jira.jelly.UserAwareDynaBeanTagSupport;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.web.bean.PagerFilter;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class RunSearchRequest
extends UserAwareDynaBeanTagSupport {
    private static final Logger log = Logger.getLogger(RunSearchRequest.class);
    protected static final String KEY_CUSTOM_FIELD_ID = "cfid";
    protected static final String KEY_CUSTOM_FIELD_VALUE = "cfvalue";
    protected static final String KEY_VARIABLE_NAME = "var";
    protected static final String KEY_SIZE_VARIABLE_NAME = "size-var";
    protected static final String KEY_FILTER_ID = "filterid";

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        Map<String, Object> requestCacheMap = JiraAuthenticationContextImpl.getRequestCache();
        try {
            SearchRequest searchRequest = this.getSearchRequest();
            JiraAuthenticationContextImpl.clearRequestCache();
            SearchProvider searchProvider = (SearchProvider)ComponentAccessor.getComponentOfType(SearchProvider.class);
            SearchResults results = searchProvider.search(searchRequest != null ? searchRequest.getQuery() : null, this.getUser(), PagerFilter.getUnlimitedFilter());
            List issueObjs = results.getIssues();
            Collection<GenericValue> issues = this.getIssueGvs(issueObjs);
            String variableName = (String)this.getProperties().get(KEY_VARIABLE_NAME);
            this.getContext().setVariable(variableName, issues);
            String sizeVariableName = (String)this.getProperties().get(KEY_SIZE_VARIABLE_NAME);
            if (TextUtils.stringSet((String)sizeVariableName)) {
                this.getContext().setVariable(sizeVariableName, (Object)new Integer(issues.size()));
            }
        }
        catch (SearchException e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
        finally {
            if (requestCacheMap != null) {
                JiraAuthenticationContextImpl.getRequestCache().putAll(requestCacheMap);
            }
        }
    }

    private Collection<GenericValue> getIssueGvs(List<Issue> issueObjs) {
        if (issueObjs == null || issueObjs.isEmpty()) {
            return Collections.emptyList();
        }
        IssueManager issueManager = ComponentAccessor.getIssueManager();
        ArrayList<Long> issueIds = new ArrayList<Long>(issueObjs.size());
        for (Issue issueObj : issueObjs) {
            issueIds.add(issueObj.getId());
        }
        return issueManager.getIssues(issueIds);
    }

    protected SearchRequest getSearchRequest() throws JellyTagException {
        String filterId = (String)this.getProperties().get(KEY_FILTER_ID);
        String cfId = (String)this.getProperties().get(KEY_CUSTOM_FIELD_ID);
        String cfValue = (String)this.getProperties().get(KEY_CUSTOM_FIELD_VALUE);
        if (StringUtils.isNotEmpty((String)filterId)) {
            return this.buildSearchRequestFromFilter(filterId);
        }
        return this.buildSearchRequestFromCustomField(cfId, cfValue);
    }

    private SearchRequest buildSearchRequestFromCustomField(String cfId, String cfValue) throws JellyTagException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        if (StringUtils.isNotEmpty((String)cfId)) {
            String[] cfValues = new String[]{cfValue};
            CustomField customField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(cfId);
            if (customField != null) {
                params.put(customField.getId(), cfValues);
            } else {
                throw new JellyTagException("Custom field with id '" + cfId + "' does not exist.");
            }
        }
        return ((SearchRequestFactory)ComponentAccessor.getComponent(SearchRequestFactory.class)).createFromParameters(null, this.getUser(), new ActionParamsImpl(params));
    }

    private SearchRequest buildSearchRequestFromFilter(String filterId) throws JellyTagException {
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getUser());
        SearchRequest searchRequest = ComponentManager.getInstance().getSearchRequestService().getFilter((JiraServiceContext)ctx, new Long(filterId));
        if (searchRequest != null) {
            return searchRequest;
        }
        throw new JellyTagException("Search Filter with id " + filterId + " did not exist");
    }
}

