/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;

public class LoadComponent
extends JiraDynaBeanTagSupport {
    private static final transient Logger log = Logger.getLogger(LoadComponent.class);

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        try {
            String variableName = (String)this.getProperties().get("var");
            String className = (String)this.getProperties().get("class");
            if (className == null) {
                throw new JellyTagException("'class' attribute not found on LoadComponent tag. Please specify the class of the component you wish to load.");
            }
            Class clazz = ClassLoaderUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            if (clazz == null) {
                throw new JellyTagException("Component with class '" + className + "' not found");
            }
            Object component = ComponentManager.getInstance().getContainer().getComponent(clazz);
            if (component == null) {
                throw new JellyTagException("Component with class '" + className + "' could not be loaded");
            }
            this.getContext().setVariable(variableName, component);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
    }
}

