/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.MovedIssueKey;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;

public class MovedIssueKeyStoreImpl
implements MovedIssueKeyStore {
    private EntityEngine entityEngine;
    private OfBizDelegator ofBizDelegator;

    public MovedIssueKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public void recordMovedIssueKey(String oldIssueKey, Long oldIssueId) {
        this.entityEngine.createValue(Entity.MOVED_ISSUE_KEY, new MovedIssueKey(null, oldIssueKey, oldIssueId));
    }

    @Override
    public Long getMovedIssueId(String key) {
        MovedIssueKey movedIssueKey = (MovedIssueKey)Select.from(Entity.MOVED_ISSUE_KEY).whereEqual("oldIssueKey", key).runWith(this.ofBizDelegator).singleValue();
        if (movedIssueKey != null) {
            return movedIssueKey.getIssueId();
        }
        return null;
    }

    @Override
    public void deleteMovedIssueKeyHistory(Long issueId) {
        this.entityEngine.delete(Delete.from(Entity.MOVED_ISSUE_KEY).whereEqual("issueId", issueId));
    }
}

