/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final OfBizDelegator ofBizDelegator;
    private final IssueEventManager issueEventManager;

    public DefaultIssueUpdater(OfBizDelegator ofBizDelegator, IssueEventManager issueEventManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueEventManager = issueEventManager;
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) {
        iub.getChangedIssue().set("updated", (Object)UtilDateTime.nowTimestamp());
        ArrayList<ChangeItemBean> modifiedFields = new ArrayList<ChangeItemBean>();
        modifiedFields.addAll(ChangeLogUtils.generateChangeItems(iub.getOriginalIssue(), iub.getChangedIssue()));
        if (iub.getChangeItems() != null) {
            modifiedFields.addAll(iub.getChangeItems());
        }
        if (!modifiedFields.isEmpty() || iub.getComment() != null) {
            this.storeModifiedFields(iub, generateChangeItems, modifiedFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeModifiedFields(IssueUpdateBean iub, boolean generateChangeItems, List<ChangeItemBean> modifiedFields) {
        GenericValue updateIssueGV = new GenericValue(iub.getChangedIssue().getDelegator(), iub.getChangedIssue().getModelEntity());
        updateIssueGV.setPKFields(iub.getChangedIssue().getPrimaryKey().getAllFields());
        for (ChangeItemBean modifiedField : modifiedFields) {
            String fieldName = modifiedField.getField();
            if ("issuetype".equals(fieldName)) {
                fieldName = "type";
            }
            if (!updateIssueGV.getModelEntity().isField(fieldName)) continue;
            updateIssueGV.put(fieldName, iub.getChangedIssue().get(fieldName));
        }
        updateIssueGV.put("updated", iub.getChangedIssue().get("updated"));
        Transaction txn = Txn.begin();
        try {
            this.ofBizDelegator.storeAll((List)ImmutableList.of((Object)updateIssueGV));
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(iub.getUser(), iub.getOriginalIssue(), iub.getChangedIssue(), (Collection<ChangeItemBean>)iub.getChangeItems(), generateChangeItems);
            txn.commit();
            if ((changeGroup != null || iub.getComment() != null) && iub.isDispatchEvent()) {
                GenericValue updatedIssue = this.ofBizDelegator.findByPrimaryKey("Issue", updateIssueGV.getLong("id"));
                IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
                this.issueEventManager.dispatchEvent(iub.getEventTypeId(), (Issue)issueFactory.getIssue(updatedIssue), iub.getUser(), iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
            }
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }
}

