/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.issue.tabpanels.CommentAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommentTabPanel
extends AbstractIssueTabPanel3 {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final CommentManager commentManager;
    private final CommentPermissionManager commentPermissionManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final FeatureManager featureManager;
    private final CommentFieldRenderer commentFieldRenderer;
    private final CommentPropertyService commentPropertyService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final int NUMBER_OF_OLD_COMMENTS_TO_SHOW = 1;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_HIDDEN_COMMENTS = 4;
    private static final int NUMBER_OF_NEW_COMMENTS_TO_SHOW = 5;
    private static final int NUMBER_OF_COMMENTS_TO_SHOW = 6;

    public CommentTabPanel(ApplicationPropertiesService applicationPropertiesService, CommentManager commentManager, CommentPermissionManager commentPermissionManager, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, DateTimeFormatter dateTimeFormatter, SoyTemplateRendererProvider soyTemplateRendererProvider, FeatureManager featureManager, CommentFieldRenderer commentFieldRenderer, CommentPropertyService commentPropertyService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.commentManager = commentManager;
        this.commentPermissionManager = commentPermissionManager;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.commentFieldRenderer = commentFieldRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.featureManager = featureManager;
        this.commentPropertyService = commentPropertyService;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    public List<IssueAction> getActions(GetActionsRequest request) {
        List<IssueAction> commentActions = this.getAllComments(request);
        if (commentActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocomments"));
            return Collections.singletonList(action);
        }
        Collections.sort(commentActions, IssueActionComparator.COMPARATOR);
        return this.limitComments(request, commentActions);
    }

    private List<IssueAction> getAllComments(GetActionsRequest request) {
        Issue issue = request.issue();
        ApplicationUser user = request.loggedInUser();
        List userComments = this.commentManager.getCommentsForUser(issue, user);
        ArrayList<IssueAction> commentActions = new ArrayList<IssueAction>();
        boolean issueIsInEditableWorkflow = this.issueManager.isEditable(issue);
        boolean canDeleteAllComments = issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteAllPermission(user, issue);
        boolean canDeleteOwnComments = canDeleteAllComments || issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteOwnPermission(user, issue);
        boolean canEditAllComments = issueIsInEditableWorkflow && this.commentPermissionManager.hasEditAllPermission(user, issue);
        boolean canEditOwnComments = canEditAllComments || issueIsInEditableWorkflow && this.commentPermissionManager.hasEditOwnPermission(user, issue);
        for (Comment comment : userComments) {
            boolean canDelete = canDeleteAllComments || canDeleteOwnComments && this.commentManager.isUserCommentAuthor(user, comment);
            boolean canEdit = canEditAllComments || canEditOwnComments && this.commentManager.isUserCommentAuthor(user, comment);
            commentActions.add((IssueAction)new CommentAction(this.descriptor, comment, canEdit, canDelete, false, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter, this.commentFieldRenderer, this.commentPropertyService, this.jiraAuthenticationContext));
        }
        return commentActions;
    }

    private List<IssueAction> limitComments(GetActionsRequest request, List<IssueAction> commentActions) {
        ApplicationProperty applicationProperty = this.applicationPropertiesService.getApplicationProperty("jira.comment.collapsing.minimum.hidden");
        Integer minimumCommentsToHide = applicationProperty != null ? Integer.parseInt(applicationProperty.getCurrentValue()) : 4;
        boolean limitComments = true;
        if (this.featureManager.isEnabled(CoreFeatures.PREVENT_COMMENTS_LIMITING) || request.isShowAll() || minimumCommentsToHide == 0 || commentActions.size() - 6 < minimumCommentsToHide || this.focusedIssueWouldBeHidden(commentActions, request.getFocusId())) {
            limitComments = false;
        }
        if (limitComments) {
            try {
                int numberHiddenComments = commentActions.size() - 6;
                String showOlder = this.soyTemplateRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.IssueTabPanels.Comment.showOlder", MapBuilder.build((Object)"issueKey", (Object)request.issue().getKey(), (Object)"numberHiddenComments", (Object)numberHiddenComments));
                ArrayList<IssueAction> limitedCommentActions = new ArrayList<IssueAction>();
                for (int i = 0; i < 1; ++i) {
                    limitedCommentActions.add((IssueAction)this.getCollapsedCommentAction((CommentAction)commentActions.get(i)));
                }
                limitedCommentActions.add((IssueAction)new GenericMessageAction(showOlder));
                limitedCommentActions.addAll(commentActions.subList(commentActions.size() - 5, commentActions.size()));
                return limitedCommentActions;
            }
            catch (SoyException e) {
                throw new RuntimeException(e);
            }
        }
        return commentActions;
    }

    private boolean focusedIssueWouldBeHidden(List<IssueAction> commentActions, String focusId) {
        if (focusId != null) {
            for (IssueAction comment : commentActions.subList(1, commentActions.size() - 5)) {
                if (!((CommentAction)comment).getComment().getId().equals(Long.valueOf(focusId))) continue;
                return true;
            }
        }
        return false;
    }

    private CommentAction getCollapsedCommentAction(CommentAction commentAction) {
        return new CommentAction(this.descriptor, commentAction.getComment(), commentAction.isCanEditComment(), commentAction.isCanDeleteComment(), true, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter, this.commentFieldRenderer, this.commentPropertyService, this.jiraAuthenticationContext);
    }
}

