/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status.category;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class StatusCategoryImpl
implements StatusCategory {
    private static final List<StatusCategory> CATEGORIES = ImmutableList.of((Object)new StatusCategoryImpl(1L, "undefined", "No Category", "medium-gray", 1L), (Object)new StatusCategoryImpl(2L, "new", "New", "blue-gray", 2L), (Object)new StatusCategoryImpl(3L, "done", "Complete", "green", 3L), (Object)new StatusCategoryImpl(4L, "indeterminate", "In Progress", "yellow", 4L));
    private static final Map<String, StatusCategory> CATEGORIES_BY_KEY;
    private static final Map<String, StatusCategory> CATEGORIES_BY_NAME;
    private static final Map<Long, StatusCategory> CATEGORIES_BY_ID;
    private final Long id;
    private final String key;
    private final String name;
    private final String colorName;
    private final Long sequence;

    private StatusCategoryImpl(Long id, String key, String name, String colorName, Long sequence) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.colorName = colorName;
        this.sequence = sequence;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        return this.getTranslatedName(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
    }

    public String getTranslatedName(String locale) {
        return this.getTranslatedName(ComponentAccessor.getI18nHelperFactory().getInstance(new Locale(locale)));
    }

    public String getTranslatedName(I18nHelper i18n) {
        return i18n.getText("common.statuscategory." + this.getKey());
    }

    public String getColorName() {
        return this.colorName;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public int compareTo(StatusCategory o) {
        return this.id.compareTo(o.getId());
    }

    public static StatusCategory findById(Long id) {
        return CATEGORIES_BY_ID.get(id);
    }

    public static StatusCategory findByKey(String key) {
        return CATEGORIES_BY_KEY.get(key);
    }

    public static StatusCategory findByName(String key) {
        return CATEGORIES_BY_NAME.get(key);
    }

    public static StatusCategory getDefault() {
        return CATEGORIES_BY_KEY.get("undefined");
    }

    public static List<StatusCategory> getAllCategories() {
        return CATEGORIES;
    }

    public static List<StatusCategory> getUserVisibleCategories() {
        return Lists.newArrayList((Iterable)Iterables.filter(CATEGORIES, (Predicate)new Predicate<StatusCategory>(){

            public boolean apply(StatusCategory statusCategory) {
                return !statusCategory.getKey().equals("undefined");
            }
        }));
    }

    static {
        CATEGORIES_BY_ID = Maps.uniqueIndex(CATEGORIES, (Function)new Function<StatusCategory, Long>(){

            public Long apply(@Nullable StatusCategory input) {
                return input.getId();
            }
        });
        CATEGORIES_BY_KEY = Maps.uniqueIndex(CATEGORIES, (Function)new Function<StatusCategory, String>(){

            public String apply(@Nullable StatusCategory input) {
                return input.getKey();
            }
        });
        CATEGORIES_BY_NAME = Maps.uniqueIndex(CATEGORIES, (Function)new Function<StatusCategory, String>(){

            public String apply(StatusCategory input) {
                return input.getName();
            }
        });
    }
}

