/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class UserSearcherHelperImpl
implements UserSearcherHelper {
    private final GroupManager groupManager;
    private final PermissionManager permissionManager;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final UserHistoryManager userHistoryManager;
    private final UserPickerSearchService userPickerSearchService;

    public UserSearcherHelperImpl(GroupManager groupManager, PermissionManager permissionManager, UserUtil userUtil, UserManager userManager, UserHistoryManager userHistoryManager, UserPickerSearchService userPickerSearchService) {
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.userHistoryManager = userHistoryManager;
        this.userPickerSearchService = userPickerSearchService;
    }

    public void addUserSuggestionParams(User user, List<String> selectedUsers, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedUsers", this.getSuggestedUsers(user, selectedUsers, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_user"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_user"));
        }
    }

    public void addUserGroupSuggestionParams(User user, List<String> selectedUsers, Map<String, Object> params) {
        this.addUserGroupSuggestionParams(user, selectedUsers, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY, params);
    }

    public void addUserGroupSuggestionParams(User user, List<String> selectedUsers, UserSearchParams searchParams, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        if (searchParams != null) {
            params.put("suggestedUsers", ApplicationUsers.toDirectoryUsers(this.getSuggestedUsers(user, selectedUsers, searchParams)));
        }
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_usergroup"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_usergroup"));
        }
    }

    public void addGroupSuggestionParams(User user, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_group"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_group"));
        }
    }

    List<Group> getSuggestedGroups(User user) {
        ArrayList groups = new ArrayList();
        if (user != null) {
            groups.addAll(this.groupManager.getGroupsForUser(user));
        } else if (this.hasUserPickingPermission(user)) {
            groups.addAll(this.groupManager.getAllGroups());
        } else {
            return null;
        }
        Collections.sort(groups, new GroupNameComparator());
        return groups.subList(0, Math.min(5, groups.size()));
    }

    List<ApplicationUser> getSuggestedUsers(User user, List<String> selectedUserNames, UserSearchParams searchParams) {
        ApplicationUser appUser = ApplicationUsers.from((User)user);
        if (this.hasUserPickingPermission(appUser)) {
            int limit = 5;
            LinkedHashSet<ApplicationUser> suggestedUsers = new LinkedHashSet<ApplicationUser>();
            Collection<ApplicationUser> recentlyUsedUsers = this.getRecentlyUsedUsers(appUser);
            this.addToSuggestList(limit, suggestedUsers, recentlyUsedUsers, selectedUserNames, searchParams);
            if (suggestedUsers.size() < limit && this.userUtil.getActiveUserCount() <= 10) {
                List allUsers = this.userPickerSearchService.findUsers("", searchParams);
                if (!recentlyUsedUsers.isEmpty()) {
                    selectedUserNames = Lists.newArrayList(selectedUserNames);
                    selectedUserNames.addAll(Collections2.transform(recentlyUsedUsers, (Function)new Function<ApplicationUser, String>(){

                        public String apply(@Nullable ApplicationUser input) {
                            return input.getName();
                        }
                    }));
                }
                Collections.sort(allUsers, new UserCachingComparator());
                List allAppUsers = Lists.transform((List)allUsers, (Function)new Function<User, ApplicationUser>(){

                    public ApplicationUser apply(@Nullable User input) {
                        return ApplicationUsers.from((User)input);
                    }
                });
                this.addToSuggestList(limit, suggestedUsers, allAppUsers, selectedUserNames, searchParams);
            }
            return ImmutableList.copyOf(suggestedUsers);
        }
        return null;
    }

    void addToSuggestList(int limit, LinkedHashSet<ApplicationUser> suggestedUsers, Iterable<ApplicationUser> users, List<String> alreadySelected, UserSearchParams searchParams) {
        for (ApplicationUser user : users) {
            if (suggestedUsers.size() >= limit) break;
            if (suggestedUsers.contains(user) || alreadySelected.contains(user.getName()) || !this.userPickerSearchService.userMatches(user, searchParams)) continue;
            suggestedUsers.add(user);
        }
    }

    private Collection<ApplicationUser> getRecentlyUsedUsers(ApplicationUser user) {
        Function<String, ApplicationUser> toUser = new Function<String, ApplicationUser>(){

            public ApplicationUser apply(@Nullable String input) {
                return input == null ? null : UserSearcherHelperImpl.this.userManager.getUserByName(input);
            }
        };
        Function historyItemToUser = Functions.compose((Function)toUser, (Function)UserHistoryItem.GET_ENTITY_ID);
        return new LinkedHashSet<ApplicationUser>(Collections2.filter((Collection)Lists.transform((List)this.userHistoryManager.getHistory(UserHistoryItem.USED_USER, user), (Function)historyItemToUser), (Predicate)Predicates.notNull()));
    }

    public boolean hasUserPickingPermission(User user) {
        return this.hasUserPickingPermission(ApplicationUsers.from((User)user));
    }

    public boolean hasUserPickingPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(27, user);
    }

    private I18nHelper getI18n(User user) {
        return ((I18nHelper.BeanFactory)ComponentAccessor.getComponent(I18nHelper.BeanFactory.class)).getInstance(user);
    }
}

