/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CustomFieldLabelsSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer {
    private final ClauseNames clauseNames;

    public CustomFieldLabelsSearchInputTransformer(CustomField field, String urlParameterName, CustomFieldInputHelper customFieldInputHelper, ClauseNames clauseNames) {
        super(field, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
    }

    protected Clause getClauseFromParams(User user, CustomFieldParams customFieldParams) {
        Collection searchValuesUnTokenized = customFieldParams.getValuesForNullKey();
        if (null != searchValuesUnTokenized && !searchValuesUnTokenized.isEmpty()) {
            HashSet<String> searchStrings = new HashSet<String>();
            for (String string : searchValuesUnTokenized) {
                String[] strings = StringUtils.split((String)string, (String)" ");
                searchStrings.addAll(Arrays.asList(strings));
            }
            if (searchStrings.size() == 1) {
                String sanitizedLabel = ((String)searchStrings.iterator().next()).trim();
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.EQUALS, (Operand)new SingleValueOperand(sanitizedLabel));
            }
            ArrayList<SingleValueOperand> operands = new ArrayList<SingleValueOperand>();
            for (String label : searchStrings) {
                String sanitizedLabel = label.trim();
                operands.add(new SingleValueOperand(sanitizedLabel.trim()));
            }
            return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.IN, (Operand)new MultiValueOperand(operands));
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(User user, Query query, SearchContext searchContext) {
        QueryInputPlaceHolder queryInputPlaceHolder = this.getQueryInputPlaceHolder(query);
        return queryInputPlaceHolder.isConveratableToSimple() ? new CustomFieldParamsImpl(this.getCustomField(), queryInputPlaceHolder.getValues()) : null;
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        return this.getQueryInputPlaceHolder(query).isConveratableToSimple();
    }

    private QueryInputPlaceHolder getQueryInputPlaceHolder(Query query) {
        SimpleNavigatorCollectorVisitor labelsClauseVisitor = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)labelsClauseVisitor);
            if (labelsClauseVisitor.isValid()) {
                List terminalClauses = labelsClauseVisitor.getClauses();
                LinkedHashSet<String> searchValues = new LinkedHashSet<String>(terminalClauses.size());
                boolean queryFitsSimple = true;
                for (TerminalClause terminalClause : terminalClauses) {
                    if (terminalClause.getOperator().equals((Object)Operator.EQUALS) || terminalClause.getOperator().equals((Object)Operator.IN)) {
                        Operand operand = terminalClause.getOperand();
                        if (operand instanceof SingleValueOperand) {
                            searchValues.add(this.getOperandValue(operand));
                            continue;
                        }
                        if (!(operand instanceof MultiValueOperand)) continue;
                        List list = ((MultiValueOperand)operand).getValues();
                        for (Operand singleOperand : list) {
                            searchValues.add(this.getOperandValue(singleOperand));
                        }
                        continue;
                    }
                    queryFitsSimple = false;
                }
                return new QueryInputPlaceHolder(queryFitsSimple, searchValues);
            }
        }
        return new QueryInputPlaceHolder(false, Collections.emptySet());
    }

    private String getOperandValue(Operand operand) {
        SingleValueOperand singleValueOperand = (SingleValueOperand)operand;
        if (singleValueOperand.getStringValue() != null) {
            return singleValueOperand.getStringValue();
        }
        return singleValueOperand.getLongValue().toString();
    }

    private static class QueryInputPlaceHolder {
        private final boolean converatableToSimple;
        private final Set<String> values;

        private QueryInputPlaceHolder(boolean converatableToSimple, Set<String> values) {
            this.converatableToSimple = converatableToSimple;
            this.values = values;
        }

        public boolean isConveratableToSimple() {
            return this.converatableToSimple;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }
}

