/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractUserSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ParameterStore;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.List;
import java.util.Map;

public class CreatorSearchRenderer
extends AbstractUserSearchRenderer
implements SearchRenderer {
    private final FieldVisibilityManager fieldVisibilityManager;

    public CreatorSearchRenderer(String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, UserPickerSearchService searchService, UserManager userManager, PermissionManager permissionManager, FieldVisibilityManager fieldVisibilityManager) {
        super(SystemSearchConstants.forCreator(), nameKey, velocityRequestContextFactory, applicationProperties, templatingEngine, searchService, userManager, permissionManager);
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    protected List<Map<String, String>> getSelectedListOptions(User searcher) {
        ParameterStore parameterStore = new ParameterStore(searcher);
        return parameterStore.getCreatorTypes();
    }

    @Override
    protected String getEmptyValueKey() {
        return "common.concepts.anonymous.creator";
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(SystemSearchConstants.forCreator().getFieldId(), searchContext, user);
    }
}

