/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.GroupTextOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.OptionWithValidity;
import com.atlassian.jira.issue.search.searchers.renderer.Options;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SelectedValues;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInput;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.util.CollectionUtils;
import webwork.action.Action;

public abstract class AbstractProjectConstantsRenderer<I extends SearchInput, O extends Options>
extends AbstractSearchRenderer
implements SearchRenderer {
    private static final String OPTION_ID_PREFIX = "id:";
    protected final ProjectManager projectManager;
    protected final SimpleFieldSearchConstantsWithEmpty searchConstants;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final PermissionManager permissionManager;

    AbstractProjectConstantsRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, SimpleFieldSearchConstantsWithEmpty searchConstants, ProjectManager projectManager, String searcherNameKey, PermissionManager permissionManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants.getSearcherId(), searcherNameKey);
        this.searchConstants = searchConstants;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    static String createId(String value) {
        return OPTION_ID_PREFIX + StringEscapeUtils.escapeHtml((String)value);
    }

    public boolean isRelevantForQuery(User user, Query query) {
        return this.isRelevantForQuery(this.searchConstants.getJqlClauseNames(), query);
    }

    public boolean isShown(User user, SearchContext searchContext) {
        return !this.getSelectListOptions(user, searchContext).isEmpty() && !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.searchConstants.getFieldId(), searchContext, user);
    }

    List<Option> getSelectListOptions(User searcher, SearchContext searchContext) {
        return ((Options)this.getValidOptions(searcher, searchContext)).all();
    }

    abstract O getValidOptions(User var1, SearchContext var2);

    public String getEditHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addEditParameters(user, searchContext, fieldValuesHolder, velocityParameters);
        return this.renderEditTemplate("project-constants-searcher-edit.vm", velocityParameters);
    }

    void addEditParameters(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<String, Object> velocityParameters) {
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter());
        velocityParameters.put("optionGroups", this.getOptions(searcher, selectedValues, searchContext));
        List selectedOptionKeys = CollectionUtil.transform((Iterable)selectedValues, this.inputValueToOptionIdFunction());
        velocityParameters.put("selectedValues", new SelectedValues(selectedOptionKeys));
    }

    private List<GroupTextOption> getOptions(User searcher, Collection<I> selectedValues, SearchContext searchContext) {
        O validOptions = this.getValidOptions(searcher, searchContext);
        ((Options)validOptions).no((Option)this.createBlankOption(searcher));
        Set<Option> invalidOptions = this.getInvalidOptions(searcher, selectedValues, ((Options)validOptions).all());
        ArrayList groups = Lists.newArrayList();
        this.createGroups(groups, validOptions, invalidOptions);
        return groups;
    }

    abstract OptionWithValidity createBlankOption(User var1);

    abstract void createGroups(List<GroupTextOption> var1, O var2, Set<Option> var3);

    private Set<Option> getInvalidOptions(User user, Collection<I> selectedValues, Collection<Option> allOptions) {
        TreeSet<Option> invalidOptions = new TreeSet<Option>();
        if (selectedValues != null) {
            for (SearchInput selectedValue : selectedValues) {
                String name;
                String selectedOptionId;
                if (selectedValue == null || this.isValidKey(selectedOptionId = (String)this.inputValueToOptionIdFunction().get((Object)selectedValue), allOptions) || (name = this.nameFromSelectedValue(user, selectedValue)) == null || this.isValidName(name = StringEscapeUtils.unescapeHtml((String)name), allOptions) || this.containsName(name, invalidOptions)) continue;
                invalidOptions.add((Option)new OptionWithValidity(selectedOptionId, name, false));
            }
        }
        return invalidOptions;
    }

    abstract String nameFromSelectedValue(User var1, I var2);

    abstract com.atlassian.jira.util.Function<I, String> inputValueToOptionIdFunction();

    private boolean isValidKey(String key, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getId().equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidName(String name, Collection<Option> validOptions) {
        for (Option option : validOptions) {
            if (!option.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean containsName(String name, Set<Option> options) {
        for (Option option : options) {
            if (!name.equalsIgnoreCase(option.getName())) continue;
            return true;
        }
        return false;
    }

    public String getViewHtml(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addViewParameters(user, searchContext, fieldValuesHolder, velocityParameters);
        return this.renderViewTemplate("project-constants-searcher-view.vm", velocityParameters);
    }

    void addViewParameters(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<String, Object> velocityParameters) {
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)this.searchConstants.getUrlParameter());
        Collection<GenericProjectConstantsLabel> selectedObjects = this.getSelectedLabels(searcher, selectedValues);
        O validOptions = this.getValidOptions(searcher, searchContext);
        ((Options)validOptions).no((Option)this.createBlankOption(searcher));
        velocityParameters.put("selectedObjects", this.filterDuplicateSelectedObjects(selectedObjects, ((Options)validOptions).all()));
    }

    abstract Collection<GenericProjectConstantsLabel> getSelectedLabels(User var1, Collection<I> var2);

    protected Map<String, Object> getVelocityParams(User user, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        displayParameters.put("kickass", true);
        return super.getVelocityParams(user, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
    }

    void addOption(List<GroupTextOption> options, String groupId, Option ... addOptions) {
        this.addOption(options, groupId, Arrays.asList(addOptions));
    }

    void addOption(List<GroupTextOption> options, String groupId, Collection<Option> addOptions) {
        ArrayList nonNullOptions = Lists.newArrayList();
        for (Option option : addOptions) {
            if (null == option) continue;
            nonNullOptions.add(option);
        }
        if (!nonNullOptions.isEmpty()) {
            options.add(new GroupTextOption(groupId, "", nonNullOptions));
        }
    }

    void addOption(List<GroupTextOption> options, GroupTextOption option) {
        if (null != option) {
            options.add(option);
        }
    }

    <T> Collection<GenericProjectConstantsLabel> getSelectedObjects(Collection<T> selectedValues, com.atlassian.jira.util.Function<T, GenericProjectConstantsLabel> function) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            return CollectionUtil.transform(selectedValues, function);
        }
        return null;
    }

    Collection<GenericProjectConstantsLabel> filterDuplicateSelectedObjects(Collection<GenericProjectConstantsLabel> selectedObjects, final Collection<Option> validOptions) {
        if (CollectionUtils.isEmpty(selectedObjects)) {
            return Collections.emptyList();
        }
        return Collections2.transform((Collection)ImmutableSortedSet.copyOf(selectedObjects), (Function)new Function<GenericProjectConstantsLabel, GenericProjectConstantsLabel>(){

            public GenericProjectConstantsLabel apply(GenericProjectConstantsLabel label) {
                boolean valid = false;
                String name = label.getLabel();
                for (Option option : validOptions) {
                    if (!label.isSameAs(option)) continue;
                    name = option.getName();
                    valid = true;
                    break;
                }
                return new GenericProjectConstantsLabel(name, valid);
            }
        });
    }

    boolean isValidProject(Long projectId, User searcher) {
        Project project = this.projectManager.getProjectObj(projectId);
        return project != null && this.permissionManager.hasPermission(10, project, searcher);
    }

    Collection<Project> getVisibleProjects(User searcher) {
        return this.permissionManager.getProjectObjects(10, searcher);
    }

    public static class GenericProjectConstantsLabel
    implements Comparable<GenericProjectConstantsLabel> {
        private final String browseUrl;
        private final String label;
        private final boolean valid;

        public GenericProjectConstantsLabel(String label) {
            this(label, null, true);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl) {
            this(label, browseUrl, true);
        }

        public GenericProjectConstantsLabel(String label, boolean valid) {
            this(label, null, valid);
        }

        public GenericProjectConstantsLabel(String label, String browseUrl, boolean valid) {
            this.browseUrl = browseUrl;
            this.label = label;
            this.valid = valid;
        }

        public String getLabel() {
            return this.label;
        }

        public String getBrowseUrl() {
            return this.browseUrl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isSameAs(Option option) {
            String name = option.getName();
            return null == this.label ? null == name : this.label.equalsIgnoreCase(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericProjectConstantsLabel that = (GenericProjectConstantsLabel)o;
            return !(this.label == null ? that.label != null : !this.label.equalsIgnoreCase(that.label));
        }

        public int hashCode() {
            return this.label != null ? this.label.toLowerCase().hashCode() : 0;
        }

        @Override
        public int compareTo(GenericProjectConstantsLabel genericProjectConstantsLabel) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.getLabel(), genericProjectConstantsLabel.getLabel());
        }
    }
}

