/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.filters;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class IssueIdFilter
extends Filter {
    private final Set<String> issuesIds;

    public IssueIdFilter(Set<String> issuesIds) {
        this.issuesIds = issuesIds;
    }

    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        OpenBitSet bits = new OpenBitSet((long)indexReader.maxDoc());
        TermDocs termDocs = indexReader.termDocs();
        for (String issueId : this.issuesIds) {
            Term term = new Term("issue_id", issueId);
            termDocs.seek(term);
            if (!termDocs.next()) continue;
            bits.set((long)termDocs.doc());
        }
        return bits;
    }
}

