/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class SearchContextImpl
implements SearchContext {
    private static final List<Long> ALL_PROJECTS = Collections.singletonList(null);
    private static final List<String> ALL_ISSUE_TYPES = Collections.singletonList(null);
    private static final Logger log = Logger.getLogger(SearchContextImpl.class);
    private static final Predicate LONG_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(Long.class), ObjectUtils.getIsSetPredicate());
    private static final Predicate STRING_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(String.class), ObjectUtils.getIsSetPredicate());
    protected List projectCategoryIds;
    protected List<Long> projectIds;
    protected List<String> issueTypeIds;
    protected List<Project> projects;
    protected List<IssueType> issueTypes;
    private final ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
    private final ProjectManager projectManager = ComponentAccessor.getProjectManager();

    public SearchContextImpl() {
    }

    public SearchContextImpl(List projectCategoryIds, List projectIds, List issueTypeIds) {
        this();
        this.setProjectCategoryIds(projectCategoryIds);
        this.setProjectIds(projectIds);
        this.setIssueTypeIds(issueTypeIds);
    }

    public SearchContextImpl(SearchContext searchContext) {
        this(searchContext.getProjectCategoryIds(), searchContext.getProjectIds(), searchContext.getIssueTypeIds());
    }

    public boolean isForAnyProjects() {
        return !(this.projectCategoryIds != null && !this.projectCategoryIds.isEmpty() || this.projectIds != null && !this.projectIds.isEmpty());
    }

    public boolean isForAnyIssueTypes() {
        return this.issueTypeIds == null || this.issueTypeIds.isEmpty();
    }

    public boolean isSingleProjectContext() {
        return this.getProjectIds() != null && this.getProjectIds().size() == 1;
    }

    public Project getSingleProject() {
        if (this.isSingleProjectContext()) {
            return this.projectManager.getProjectObj(this.getProjectIds().get(0));
        }
        throw new IllegalStateException("This is not a single project context");
    }

    public List getProjectCategoryIds() {
        return this.projectCategoryIds;
    }

    private void setProjectCategoryIds(List projectCategoryIds) {
        this.projectCategoryIds = SearchContextImpl.prepareProjectList(projectCategoryIds);
    }

    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    private void setProjectIds(List projectIds) {
        this.projectIds = SearchContextImpl.prepareProjectList(projectIds);
        this.projects = null;
    }

    public GenericValue getOnlyProject() {
        if (this.isSingleProjectContext()) {
            Long projectId = this.getProjectIds().get(0);
            return this.projectManager.getProject(projectId);
        }
        log.warn((Object)("Trying to get the only the project but is not a single project context. Project ids are: " + this.getProjectIds()));
        return null;
    }

    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    public List<IssueContext> getAsIssueContexts() {
        ArrayList<IssueContext> issueContexts = new ArrayList<IssueContext>();
        List<Long> projectIds = this.getProjectIds() != null && !this.getProjectIds().isEmpty() ? this.getProjectIds() : ALL_PROJECTS;
        for (Long projectId : projectIds) {
            List<String> issueTypeIds = this.getIssueTypeIds() != null && !this.getIssueTypeIds().isEmpty() ? this.getIssueTypeIds() : ALL_ISSUE_TYPES;
            for (String issueTypeId : issueTypeIds) {
                issueContexts.add((IssueContext)new IssueContextImpl(projectId, issueTypeId));
            }
        }
        return issueContexts;
    }

    public void verify() {
        Iterator<Object> iterator;
        if (this.projectIds != null && !this.projectIds.isEmpty()) {
            iterator = this.projectIds.iterator();
            while (iterator.hasNext()) {
                Long projectId = (Long)iterator.next();
                if (this.projectManager.getProject(projectId) != null) continue;
                log.warn((Object)("Project id " + projectId + " found in searchContext but is not valid. Being removed."));
                iterator.remove();
            }
        }
        if (this.issueTypeIds != null && !this.issueTypeIds.isEmpty()) {
            iterator = this.issueTypeIds.iterator();
            while (iterator.hasNext()) {
                String issueTypeId = (String)iterator.next();
                if (this.constantsManager.getIssueType(issueTypeId) != null) continue;
                log.warn((Object)("Issue type id " + issueTypeId + " found in searchContext but is not valid. Being removed."));
                iterator.remove();
            }
        }
    }

    private void setIssueTypeIds(List issueTypeIds) {
        this.issueTypeIds = ListUtils.predicatedList((List)this.constantsManager.expandIssueTypeIds((Collection)issueTypeIds), (Predicate)STRING_PREDICATE);
        this.issueTypes = null;
    }

    private static List<Long> prepareProjectList(List list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.size() == 1 && !ObjectUtils.isValueSelected(list.get(0))) {
            return Collections.emptyList();
        }
        return ListUtils.predicatedList((List)list, (Predicate)LONG_PREDICATE);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("projectCategoryIds", (Object)this.getProjectCategoryIds()).append("projectIds", this.getProjectIds()).append("issueTypeIds", this.getIssueTypeIds()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchContextImpl)) {
            return false;
        }
        SearchContextImpl rhs = (SearchContextImpl)o;
        return new EqualsBuilder().append((Object)this.getProjectCategoryIds(), (Object)rhs.getProjectCategoryIds()).append(this.getProjectIds(), rhs.getProjectIds()).append(this.getIssueTypeIds(), rhs.getIssueTypeIds()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 47).append((Object)this.getProjectCategoryIds()).append(this.getProjectIds()).append(this.getIssueTypeIds()).toHashCode();
    }

    public List<Project> getProjects() {
        if (null == this.projectIds) {
            return null;
        }
        if (null == this.projects) {
            this.projects = Lists.transform(this.projectIds, (Function)new Function<Long, Project>(){

                public Project apply(@Nullable Long projectId) {
                    return SearchContextImpl.this.projectManager.getProjectObj(projectId);
                }
            });
        }
        return this.projects;
    }

    public List<IssueType> getIssueTypes() {
        if (null == this.issueTypeIds) {
            return null;
        }
        if (null == this.issueTypes) {
            this.issueTypes = Lists.transform(this.issueTypeIds, (Function)new Function<String, IssueType>(){

                public IssueType apply(@Nullable String issueTypeId) {
                    return SearchContextImpl.this.constantsManager.getIssueTypeObject(issueTypeId);
                }
            });
        }
        return this.issueTypes;
    }
}

