/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.pager;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;

@Deprecated
@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="TODO Needs to be fixed")
public class NextPreviousPager
implements Serializable {
    private static final Logger log = Logger.getLogger(NextPreviousPager.class);
    static final int DEFAULT_CACHE_SIZE = 40;
    private static final FieldSelector FIELD_SELECTOR = new SetBasedFieldSelector(Collections.singleton("key"), Collections.emptySet());
    private int[] docIds;
    private List<String> issueKeys;
    private int currentKeyPos = -1;
    private int searchRequestHashCode = -1;
    private long readerVersion;
    private int offset;
    private int cacheSize = 40;

    public NextPreviousPager(NextPreviousPager that) {
        this.currentKeyPos = that.currentKeyPos;
        this.searchRequestHashCode = that.searchRequestHashCode;
        this.readerVersion = that.readerVersion;
        this.offset = that.offset;
        this.cacheSize = that.cacheSize;
        this.docIds = that.docIds == null ? that.docIds : (int[])that.docIds.clone();
        this.issueKeys = that.issueKeys == null ? that.issueKeys : new ArrayList<String>(that.issueKeys);
    }

    public NextPreviousPager(ApplicationProperties applicationProperties) {
        String cacheSizeStr;
        if (applicationProperties != null && !StringUtils.isBlank((String)(cacheSizeStr = applicationProperties.getDefaultBackedString("jira.previous.next.cache.size")))) {
            try {
                this.cacheSize = Integer.parseInt(cacheSizeStr);
                if (this.cacheSize < 3) {
                    log.warn((Object)"Issue key cache size can not be less than 3, Setting it to default.");
                    this.cacheSize = 40;
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"Exception thrown while trying to convert jira-application.properties key 'jira.previous.next.cache.size'. Ignoring and setting to default: '40'", (Throwable)nfe);
            }
        }
    }

    public boolean isHasCurrentKey() {
        return this.getCurrentKey() != null;
    }

    public String getCurrentKey() {
        return this.getKeyForPosition(this.currentKeyPos);
    }

    public int getCurrentPosition() {
        return this.currentKeyPos + 1;
    }

    public int getCurrentSize() {
        return this.docIds == null ? 0 : this.docIds.length;
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    public String getNextKey() {
        return this.getCurrentKey() == null ? null : this.getKeyForPosition(this.currentKeyPos + 1);
    }

    public String getPreviousKey() {
        return this.getCurrentKey() == null ? null : this.getKeyForPosition(this.currentKeyPos - 1);
    }

    public void update(SearchRequest searchRequest, User user, String currentKey) throws IOException, SearchException {
        log.warn((Object)"NextPreviousPager is no longer supported as of JIRA 6.0 because issue pager is no longer generated on the server side. This method will do nothing. Please stop using it.");
    }

    private String getKeyForPosition(int position) {
        if (position < 0 || position > this.docIds.length - 1) {
            return null;
        }
        int relativePos = position - this.offset;
        if (relativePos < 0 || relativePos > this.issueKeys.size() - 1) {
            return null;
        }
        return this.issueKeys.get(relativePos);
    }

    IndexReader getReader() {
        return ((IssueIndexManager)ComponentAccessor.getComponentOfType(IssueIndexManager.class)).getIssueSearcher().getIndexReader();
    }

    SearchProvider getSearchProvider() {
        return (SearchProvider)ComponentAccessor.getComponentOfType(SearchProvider.class);
    }
}

