/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.managers.IssueDeleteHelper;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueDeleteHelper
implements IssueDeleteHelper {
    private static final Logger log = Logger.getLogger(DefaultIssueDeleteHelper.class);
    private final IssueIndexManager indexManager;
    private final SubTaskManager subTaskManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final MailThreadManager mailThreadManager;
    private final CustomFieldManager customFieldManager;
    private final AttachmentManager attachmentManager;
    private final IssueManager issueManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final UserAssociationStore userAssociationStore;
    private final WorkflowManager workflowManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final IssueEventManager issueEventManager;
    private final EventPublisher eventPublisher;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final CommentManager commentManager;

    public DefaultIssueDeleteHelper(IssueIndexManager indexManager, SubTaskManager subTaskManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, MailThreadManager mailThreadManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, IssueManager issueManager, NodeAssociationStore nodeAssociationStore, WorkflowManager workflowManager, ChangeHistoryManager changeHistoryManager, IssueEventManager issueEventManager, UserAssociationStore userAssociationStore, EventPublisher eventPublisher, MovedIssueKeyStore movedIssueKeyStore, JsonEntityPropertyManager jsonEntityPropertyManager, CommentManager commentManager) {
        this.indexManager = indexManager;
        this.subTaskManager = subTaskManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.mailThreadManager = mailThreadManager;
        this.customFieldManager = customFieldManager;
        this.attachmentManager = attachmentManager;
        this.issueManager = issueManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.userAssociationStore = userAssociationStore;
        this.workflowManager = workflowManager;
        this.changeHistoryManager = changeHistoryManager;
        this.issueEventManager = issueEventManager;
        this.eventPublisher = eventPublisher;
        this.movedIssueKeyStore = movedIssueKeyStore;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.commentManager = commentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIssue(User user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        try {
            Long issueId = issue.getId();
            GenericValue issueGV = issue.getGenericValue();
            if (issueGV == null) {
                throw new IllegalArgumentException("The provided issue has a null GenericValue.");
            }
            DeletedIssueEventData eventData = eventDispatchOption.isEventBeingSent() ? new DeletedIssueEventData(issueId) : new DeletedIssueEventData();
            if (eventDispatchOption.isEventBeingSent()) {
                this.eventPublisher.publish((Object)new IssuePreDeleteEvent(issue, user));
            }
            Transaction txn = Txn.begin();
            try {
                this.removeChildActions(issue);
                issueGV.removeRelated("ChildWorklog");
                this.removeSubTasks(user, issue, eventDispatchOption, sendMail);
                this.removeIssueLinks(user, issue);
                this.changeHistoryManager.removeAllChangeItems(issue);
                this.deleteMovedIssueKeyHistory(issue);
                this.removeIssueProperties(issue);
                this.removeAttachments(issue);
                this.nodeAssociationStore.removeAssociationsFromSource(issueGV);
                this.userAssociationStore.removeUserAssociationsFromSink(issueGV.getEntityName(), issueGV.getLong("id"));
                this.customFieldManager.removeCustomFieldValues(issueGV);
                this.workflowManager.removeWorkflowEntries(issueGV);
                issueGV.remove();
                this.removeNotifications(issueId);
                txn.commit();
                this.deindex(issue);
                this.dispatchDeleteEvent(user, eventDispatchOption, sendMail, eventData);
            }
            finally {
                txn.finallyRollbackIfNotCommitted();
            }
        }
        catch (GenericEntityException e) {
            throw new RemoveException((Exception)((Object)e));
        }
    }

    private void removeChildActions(Issue issue) throws GenericEntityException {
        for (Comment comment : this.commentManager.getComments(issue)) {
            this.commentManager.delete(comment);
        }
        issue.getGenericValue().removeRelated("ChildAction");
    }

    private void deleteMovedIssueKeyHistory(Issue issue) {
        Long issueId = issue.getId();
        this.movedIssueKeyStore.deleteMovedIssueKeyHistory(issueId);
    }

    @Override
    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.deleteIssue(null, issue, EventDispatchOption.DO_NOT_DISPATCH, false);
    }

    private void removeIssueLinks(User user, Issue issue) throws RemoveException {
        if (issue.isSubTask()) {
            Issue parentIssue = issue.getParentObject();
            this.issueLinkManager.removeIssueLinksNoChangeItems(issue);
            this.subTaskManager.resetSequences(parentIssue);
        } else {
            this.issueLinkManager.removeIssueLinksNoChangeItems(issue);
        }
        for (RemoteIssueLink remoteIssueLink : this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue)) {
            this.remoteIssueLinkManager.removeRemoteIssueLink(remoteIssueLink.getId(), user);
        }
    }

    private void removeIssueProperties(Issue issue) {
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), issue.getId());
    }

    private void removeAttachments(Issue issue) throws RemoveException {
        for (Attachment attachment : this.attachmentManager.getAttachments(issue)) {
            this.attachmentManager.deleteAttachment(attachment);
        }
        this.attachmentManager.deleteAttachmentDirectory(issue);
    }

    private void removeNotifications(Long issueId) {
        if (issueId != null) {
            try {
                this.mailThreadManager.removeAssociatedEntries(issueId);
            }
            catch (DataAccessException e) {
                log.error((Object)("Error removing Notification Instance records for issue with id '" + issueId + "': " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected void removeSubTasks(User user, Issue parentIssue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        for (IssueLink subTaskIssueLink : this.subTaskManager.getSubTaskIssueLinks(parentIssue.getId())) {
            Issue subTaskIssue = subTaskIssueLink.getDestinationObject();
            log.debug((Object)("Deleting sub-task issue with key: " + subTaskIssue.getKey()));
            this.deleteIssue(user, subTaskIssue, eventDispatchOption, sendMail);
            log.debug((Object)("Deleted sub-task issue with key: " + subTaskIssue.getKey()));
        }
    }

    private void deindex(Issue issue) {
        try {
            this.indexManager.deIndex(issue);
        }
        catch (Exception issueDeIndexException) {
            log.error((Object)("Error deindexing issue: [" + issue.getKey() + "] " + issue.getSummary() + ":" + issueDeIndexException), (Throwable)issueDeIndexException);
        }
    }

    private void dispatchDeleteEvent(User user, EventDispatchOption eventDispatchOption, boolean sendMail, DeletedIssueEventData eventData) {
        if (eventDispatchOption.isEventBeingSent()) {
            this.issueEventManager.dispatchEvent(eventDispatchOption.getEventTypeId(), eventData.issue, eventData.paramsMap(), user, sendMail);
        }
    }

    private class DeletedIssueEventData {
        private final Issue issue;
        private final Map<String, Object> customFieldValues;
        private final List<User> watchers;

        DeletedIssueEventData(Long issueId) {
            this.issue = DefaultIssueDeleteHelper.this.issueManager.getIssueObject(issueId);
            this.issue.getParentId();
            this.customFieldValues = this.collectCustomFieldValues();
            this.watchers = DefaultIssueDeleteHelper.this.issueManager.getWatchers(this.issue);
        }

        DeletedIssueEventData() {
            this.issue = null;
            this.customFieldValues = null;
            this.watchers = null;
        }

        private Map<String, Object> collectCustomFieldValues() {
            ImmutableMap.Builder answerBuilder = ImmutableMap.builder();
            for (CustomField customField : DefaultIssueDeleteHelper.this.customFieldManager.getCustomFieldObjects(this.issue)) {
                Object value = customField.getValue(this.issue);
                if (value == null) continue;
                answerBuilder.put((Object)customField.getId(), value);
            }
            return answerBuilder.build();
        }

        private Map<String, Object> paramsMap() {
            HashMap builder = Maps.newHashMap();
            if (this.customFieldValues != null) {
                builder.put(IssueEvent.CUSTOM_FIELDS_PARAM_NAME, this.customFieldValues);
            }
            if (this.watchers != null) {
                builder.put(IssueEvent.WATCHERS_PARAM_NAME, this.watchers);
            }
            return !builder.isEmpty() ? ImmutableMap.copyOf((Map)builder) : null;
        }
    }
}

