/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comparator.CustomFieldComparators;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.issue.fields.CustomFieldImpl;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCustomFieldManager
implements CustomFieldManager {
    private static final Logger log = Logger.getLogger(DefaultCustomFieldManager.class);
    private static final Comparator<CustomFieldType<?, ?>> NAME_ORDER = new Comparator<CustomFieldType<?, ?>>(){
        private final Ordering<String> string = Ordering.natural().nullsFirst();

        @Override
        public int compare(CustomFieldType<?, ?> o1, CustomFieldType<?, ?> o2) {
            return this.string.compare((Object)o1.getName(), (Object)o2.getName());
        }
    };
    private final PluginAccessor pluginAccessor;
    private final OfBizDelegator delegator;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FieldConfigContextPersister contextPersister;
    private final FieldScreenManager fieldScreenManager;
    private final RendererManager rendererManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final NotificationSchemeManager notificationSchemeManager;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;
    private final EventPublisher eventPublisher;
    private final CustomFieldDescription customFieldDescription;
    private final I18nHelper.BeanFactory i18nFactory;
    private final FeatureManager featureManager;
    private final TranslationManager translationManager;
    private final Cache<Long, CacheObject<CustomField>> customFieldsById;
    private final Cache<String, List<Long>> customFieldsByName;
    private final CachedReference<List<Long>> allCustomFieldIds;

    public DefaultCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, FieldConfigSchemeManager fieldConfigSchemeManager, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, ProjectManager projectManager, PermissionManager permissionManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, RendererManager rendererManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, EventPublisher eventPublisher, CustomFieldDescription customFieldDescription, I18nHelper.BeanFactory i18nFactory, FeatureManager featureManager, TranslationManager translationManager, CacheManager cacheManager) {
        this.pluginAccessor = pluginAccessor;
        this.delegator = delegator;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.contextPersister = contextPersister;
        this.fieldScreenManager = fieldScreenManager;
        this.rendererManager = rendererManager;
        this.customFieldValuePersister = customFieldValuePersister;
        this.notificationSchemeManager = notificationSchemeManager;
        this.fieldManager = fieldManager;
        this.fieldConfigSchemeClauseContextUtil = fieldConfigSchemeClauseContextUtil;
        this.eventPublisher = eventPublisher;
        this.customFieldDescription = customFieldDescription;
        this.i18nFactory = i18nFactory;
        this.featureManager = featureManager;
        this.translationManager = translationManager;
        this.customFieldsById = cacheManager.getCache(DefaultCustomFieldManager.class.getName() + ".customFieldsById", (CacheLoader)new CustomFieldByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.customFieldsByName = cacheManager.getCache(DefaultCustomFieldManager.class.getName() + ".customFieldsByName", (CacheLoader)new CustomFieldByNameCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.allCustomFieldIds = cacheManager.getCachedReference(DefaultCustomFieldManager.class, "allCustomFieldIds", (Supplier)new AllCustomFieldIdsSupplier());
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public CustomField createCustomField(String fieldName, String description, CustomFieldType fieldType, CustomFieldSearcher customFieldSearcher, List contexts, List issueTypes) throws GenericEntityException {
        HashMap<String, String> createFields = new HashMap<String, String>();
        createFields.put("name", StringUtils.abbreviate((String)fieldName, (int)254));
        createFields.put("customfieldtypekey", fieldType.getKey());
        if (StringUtils.isNotEmpty((String)description)) {
            createFields.put("description", description);
        }
        if (customFieldSearcher != null) {
            createFields.put("customfieldsearcherkey", customFieldSearcher.getDescriptor().getCompleteKey());
        }
        GenericValue customFieldGV = this.delegator.createValue("CustomField", createFields);
        CustomFieldImpl customField = new CustomFieldImpl(customFieldGV, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil, this.customFieldDescription, this.i18nFactory, this.featureManager, this.translationManager);
        this.eventPublisher.publish((Object)new CustomFieldCreatedEvent((CustomField)customField));
        this.associateCustomFieldContext(customField, contexts, issueTypes);
        this.customFieldsById.remove((Object)customField.getIdAsLong());
        this.customFieldsByName.remove((Object)fieldName);
        this.allCustomFieldIds.reset();
        this.refreshConfigurationSchemes(customField.getIdAsLong());
        this.fieldManager.refresh();
        return this.getCustomFieldObject(customFieldGV.getLong("id"));
    }

    public void associateCustomFieldContext(CustomField customField, List<JiraContextNode> contexts, List<GenericValue> issueTypes) {
        if (contexts != null && !contexts.isEmpty()) {
            this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, contexts, issueTypes);
        }
    }

    @Nonnull
    public List<CustomFieldType<?, ?>> getCustomFieldTypes() {
        List types = this.pluginAccessor.getEnabledModulesByClass(CustomFieldType.class);
        ArrayList field = Lists.newArrayListWithExpectedSize((int)types.size());
        for (Object enabledModulesByClas : types) {
            field.add((CustomFieldType)enabledModulesByClas);
        }
        Collections.sort(field, NAME_ORDER);
        return field;
    }

    public CustomFieldType getCustomFieldType(String key) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldTypeModuleDescriptor) {
            return (CustomFieldType)module.getModule();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Could not load custom field type plugin with key '" + key + "'. Is the plugin present and enabled?"));
        }
        return null;
    }

    @Nonnull
    public List<CustomFieldSearcher> getCustomFieldSearchers(CustomFieldType customFieldType) {
        List allFieldSearchers = this.pluginAccessor.getEnabledModulesByClass(CustomFieldSearcher.class);
        ArrayList<CustomFieldSearcher> customFieldSearchers = new ArrayList<CustomFieldSearcher>();
        CustomFieldTypeModuleDescriptor customFieldTypeDescriptor = customFieldType.getDescriptor();
        for (CustomFieldSearcher searcher : allFieldSearchers) {
            if (!searcher.getDescriptor().getValidCustomFieldKeys().contains(customFieldType.getKey()) && !customFieldTypeDescriptor.getValidSearcherKeys().contains(searcher.getDescriptor().getCompleteKey())) continue;
            customFieldSearchers.add(searcher);
        }
        return customFieldSearchers;
    }

    public CustomFieldSearcher getCustomFieldSearcher(String key) {
        if (!ObjectUtils.isValueSelected((Object)key)) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module instanceof CustomFieldSearcherModuleDescriptor) {
            Class searcherClazz = ((CustomFieldSearcherModuleDescriptor)module).getModuleClass();
            CustomFieldSearcher cfSearcher = this.loadSearcher(searcherClazz);
            cfSearcher.init((CustomFieldSearcherModuleDescriptor)module);
            return cfSearcher;
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    @Nullable
    public CustomFieldSearcher getDefaultSearcher(@Nonnull CustomFieldType<?, ?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type == null");
        return (CustomFieldSearcher)Iterables.getFirst(this.getCustomFieldSearchers(type), null);
    }

    CustomFieldSearcher loadSearcher(Class<CustomFieldSearcher> searcherClazz) {
        return JiraUtils.loadComponent(searcherClazz);
    }

    public Class<? extends CustomFieldSearcher> getCustomFieldSearcherClass(String key) {
        if (!ObjectUtils.isValueSelected((Object)key)) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module instanceof CustomFieldSearcherModuleDescriptor) {
            return ((CustomFieldSearcherModuleDescriptor)module).getModuleClass();
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    public void refreshConfigurationSchemes(Long customFieldId) {
        this.fieldConfigSchemeManager.init();
        this.customFieldsById.remove((Object)customFieldId);
    }

    public List<CustomField> getCustomFieldObjects(Issue issue) {
        return this.getCustomFieldObjects(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    public List<CustomField> getCustomFieldObjects(GenericValue issue) {
        return this.getCustomFieldObjects(issue.getLong("project"), issue.getString("type"));
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, String issueTypeId) {
        ArrayList issueTypes = issueTypeId == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeId});
        return this.getCustomFieldObjects(projectId, issueTypes);
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, List<String> issueTypeIds) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        Project project = this.projectManager.getProjectObj(projectId);
        issueTypeIds = this.constantsManager.expandIssueTypeIds(issueTypeIds);
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(project, issueTypeIds)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    public List<CustomField> getCustomFieldObjects(SearchContext searchContext) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(searchContext)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    public CustomField getCustomFieldObject(Long id) {
        CustomField customField = (CustomField)((CacheObject)this.customFieldsById.get((Object)id)).getValue();
        return customField == null ? null : new CustomFieldImpl(customField);
    }

    public CustomField getCustomFieldObject(String key) {
        Long id = CustomFieldUtils.getCustomFieldId((String)key);
        if (id != null) {
            return this.getCustomFieldObject(id);
        }
        return null;
    }

    public boolean exists(String key) {
        Long id = CustomFieldUtils.getCustomFieldId((String)key);
        return id != null && ((CacheObject)this.customFieldsById.get((Object)id)).hasValue();
    }

    public CustomField getCustomFieldObjectByName(String customFieldName) {
        Collection<CustomField> values = this.getCustomFieldObjectsByName(customFieldName);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (values.size() > 1) {
            log.warn((Object)("Warning: returning 1 of " + values.size() + " custom fields named '" + customFieldName + "'"));
            if (log.isDebugEnabled()) {
                Thread.dumpStack();
            }
        }
        return this.getCustomFieldObjectsByName(customFieldName).iterator().next();
    }

    public Collection<CustomField> getCustomFieldObjectsByName(String customFieldName) {
        List ids = (List)this.customFieldsByName.get((Object)customFieldName);
        List<CustomField> customFields = this.getCustomFieldsFromIds(ids);
        return ImmutableList.copyOf(customFields);
    }

    public List<CustomField> getCustomFieldObjects() {
        List ids = (List)this.allCustomFieldIds.get();
        List<CustomField> customFields = this.getCustomFieldsFromIds(ids);
        Collections.sort(customFields, CustomFieldComparators.byName());
        return ImmutableList.copyOf(customFields);
    }

    private List<CustomField> getCustomFieldsFromIds(List<Long> ids) {
        ArrayList<CustomField> customFields = new ArrayList<CustomField>();
        for (Long id : ids) {
            CustomField customField = (CustomField)((CacheObject)this.customFieldsById.get((Object)id)).getValue();
            if (customField == null) continue;
            customFields.add(new CustomFieldImpl(customField));
        }
        return customFields;
    }

    public List<CustomField> getGlobalCustomFieldObjects() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getCustomFieldObjects(), (Predicate)new Predicate<CustomField>(){

            public boolean apply(CustomField cf) {
                return cf.isGlobal();
            }
        }));
    }

    public synchronized void refresh() {
        this.fieldConfigSchemeManager.init();
        this.customFieldsById.removeAll();
        this.customFieldsByName.removeAll();
        this.allCustomFieldIds.reset();
        this.refreshSearchersAndIndexers();
    }

    private synchronized void refreshSearchersAndIndexers() {
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponentOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    public void clear() {
        this.customFieldsById.removeAll();
        this.customFieldsByName.removeAll();
        this.allCustomFieldIds.reset();
        ComponentAccessor.getFieldLayoutManager().refresh();
    }

    public void removeCustomFieldPossiblyLeavingOrphanedData(Long customFieldId) throws RemoveException {
        Assertions.notNull((String)"id", (Object)customFieldId);
        CustomField originalCustomField = this.getCustomFieldObject(customFieldId);
        if (originalCustomField != null) {
            this.removeCustomField(originalCustomField);
        } else {
            log.debug((Object)("Couldn't load customfield object for id '" + customFieldId + "'.  Trying to lookup field directly via the db." + "  Please note that deleting a custom field this way may leave some custom field data behind."));
            GenericValue customFieldGv = this.delegator.findById("CustomField", customFieldId);
            if (customFieldGv != null) {
                log.debug((Object)("Customfield with id '" + customFieldId + "' retrieved successfully via the db."));
                String customFieldStringId = "customfield_" + customFieldId;
                this.removeCustomFieldAssociations(customFieldStringId);
                this.customFieldValuePersister.removeAllValues(customFieldStringId);
                try {
                    customFieldGv.remove();
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException("Error deleting custom field gv with id '" + customFieldId + "'", (Throwable)e);
                }
                this.fieldManager.refresh();
            } else {
                throw new IllegalArgumentException("Tried to remove custom field with id '" + customFieldId + "' that doesn't exist!");
            }
        }
    }

    public void removeCustomField(CustomField customField) throws RemoveException {
        this.removeCustomFieldAssociations(customField.getId());
        customField.remove();
        this.customFieldsById.remove((Object)customField.getIdAsLong());
        this.customFieldsByName.remove((Object)customField.getName());
        this.allCustomFieldIds.reset();
        this.refreshSearchersAndIndexers();
        this.fieldManager.refresh();
    }

    private void removeCustomFieldAssociations(String customFieldId) throws RemoveException {
        this.fieldScreenManager.removeFieldScreenItems(customFieldId);
        this.delegator.removeByAnd("ColumnLayoutItem", (Map)FieldMap.build((String)"fieldidentifier", (Object)customFieldId));
        this.delegator.removeByAnd("FieldLayoutItem", (Map)FieldMap.build((String)"fieldidentifier", (Object)customFieldId));
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customFieldId);
        this.notificationSchemeManager.removeSchemeEntitiesForField(customFieldId);
    }

    public void removeCustomFieldValues(GenericValue issue) throws GenericEntityException {
        this.delegator.removeByAnd("CustomFieldValue", (Map)FieldMap.build((String)"issue", (Object)issue.getLong("id")));
    }

    public void updateCustomField(CustomField customField) {
        CustomField oldField = this.getCustomFieldObject(customField.getIdAsLong());
        if (oldField == null) {
            throw new DataAccessException("Cannot update custom field that does not exist");
        }
        GenericValue customFieldGV = ((CustomFieldImpl)customField).getGenericValue();
        try {
            customFieldGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Exception whilst trying to store genericValue " + customFieldGV + ".", (Throwable)e);
        }
        this.eventPublisher.publish((Object)new CustomFieldUpdatedEvent(customField, oldField));
        this.customFieldsById.remove((Object)customField.getIdAsLong());
        this.customFieldsByName.remove((Object)customField.getName());
        String oldName = oldField.getName();
        if (!customField.getName().equals(oldName)) {
            this.customFieldsByName.remove((Object)oldName);
        }
        if (customField.getCustomFieldSearcher() != oldField.getCustomFieldSearcher()) {
            this.refreshSearchersAndIndexers();
        }
        if (!this.areConfigSchemesEqual(customField.getConfigurationSchemes(), oldField.getConfigurationSchemes())) {
            this.fieldManager.refresh();
        }
    }

    @VisibleForTesting
    protected boolean areConfigSchemesEqual(List<FieldConfigScheme> schemes, List<FieldConfigScheme> otherSchemes) {
        if (schemes != null && otherSchemes != null) {
            return HashMultiset.create(schemes).equals((Object)HashMultiset.create(otherSchemes));
        }
        return schemes == null && otherSchemes == null;
    }

    public CustomField getCustomFieldInstance(GenericValue customFieldGv) {
        return new CustomFieldImpl(customFieldGv, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil, this.customFieldDescription, this.i18nFactory, this.featureManager, this.translationManager);
    }

    public void removeProjectAssociations(GenericValue project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    public void removeProjectAssociations(Project project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    public void removeProjectCategoryAssociations(ProjectCategory projectCategory) {
        this.contextPersister.removeContextsForProjectCategory(projectCategory);
        this.refresh();
    }

    private List<Long> getCustomFieldIds(EntityCondition condition) {
        List customFieldGvs = this.delegator.findByCondition("CustomField", condition, Collections.singletonList("id"));
        ArrayList ids = Lists.newArrayListWithCapacity((int)customFieldGvs.size());
        for (GenericValue customFieldGv : customFieldGvs) {
            ids.add(customFieldGv.getLong("id"));
        }
        return ids;
    }

    private class AllCustomFieldIdsSupplier
    implements Supplier<List<Long>> {
        private AllCustomFieldIdsSupplier() {
        }

        public List<Long> get() {
            return DefaultCustomFieldManager.this.getCustomFieldIds(null);
        }
    }

    private class CustomFieldByNameCacheLoader
    implements CacheLoader<String, List<Long>> {
        private CustomFieldByNameCacheLoader() {
        }

        public List<Long> load(@Nonnull String name) {
            EntityExpr condition = new EntityExpr("name", EntityOperator.EQUALS, (Object)name);
            return DefaultCustomFieldManager.this.getCustomFieldIds((EntityCondition)condition);
        }
    }

    private class CustomFieldByIdCacheLoader
    implements CacheLoader<Long, CacheObject<CustomField>> {
        private CustomFieldByIdCacheLoader() {
        }

        public CacheObject<CustomField> load(@Nonnull Long id) {
            GenericValue customFieldGv = DefaultCustomFieldManager.this.delegator.findById("CustomField", id);
            if (customFieldGv == null) {
                return CacheObject.NULL();
            }
            CustomFieldImpl customFieldImpl = new CustomFieldImpl(customFieldGv, DefaultCustomFieldManager.this, DefaultCustomFieldManager.this.authenticationContext, DefaultCustomFieldManager.this.constantsManager, DefaultCustomFieldManager.this.fieldConfigSchemeManager, DefaultCustomFieldManager.this.permissionManager, DefaultCustomFieldManager.this.rendererManager, DefaultCustomFieldManager.this.fieldConfigSchemeClauseContextUtil, DefaultCustomFieldManager.this.customFieldDescription, DefaultCustomFieldManager.this.i18nFactory, DefaultCustomFieldManager.this.featureManager, DefaultCustomFieldManager.this.translationManager);
            if (customFieldImpl.getCustomFieldType() == null) {
                return CacheObject.NULL();
            }
            List configForCustomField = DefaultCustomFieldManager.this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customFieldImpl);
            customFieldImpl.setConfigurationSchemes(configForCustomField);
            return CacheObject.wrap(customFieldImpl);
        }
    }
}

