/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;

public class TokenFilters {

    public static class English {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenFilter apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new EnglishStemmer());
                    }
                };
            }

            public static Function<TokenStream, TokenStream> moderate() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenFilter apply(TokenStream input) {
                        return new KStemFilter(input);
                    }
                };
            }

            public static Function<TokenStream, TokenStream> minimal() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenFilter apply(TokenStream input) {
                        return new EnglishMinimalStemFilter(input);
                    }
                };
            }
        }
    }

    public static class Italian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> agressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new ItalianStemmer());
                    }
                };
            }
        }
    }

    public static class Greek {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> standard() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new GreekStemFilter(input);
                    }
                };
            }
        }
    }

    public static class German {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> standard() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new GermanStemFilter(input);
                    }
                };
            }
        }
    }

    public static class French {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new FrenchStemmer());
                    }
                };
            }
        }
    }

    public static class Czech {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> standard() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new CzechStemFilter(input);
                    }
                };
            }
        }
    }

    public static class Portuguese {

        public static class Portugal {

            public static class Stemming {
                public static Function<TokenStream, TokenStream> aggressive() {
                    return new Function<TokenStream, TokenStream>(){

                        public TokenStream apply(TokenStream input) {
                            return new SnowballFilter(input, (SnowballProgram)new PortugueseStemmer());
                        }
                    };
                }
            }
        }

        public static class Brazil {

            public static class Stemming {
                public static Function<TokenStream, TokenStream> standard() {
                    return new Function<TokenStream, TokenStream>(){

                        public TokenStream apply(TokenStream input) {
                            return new BrazilianStemFilter(input);
                        }
                    };
                }
            }
        }
    }

    public static class Bulgarian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> standard() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new BulgarianStemFilter(input);
                    }
                };
            }
        }
    }

    public static class Swedish {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new SwedishStemmer());
                    }
                };
            }
        }
    }

    public static class Spanish {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new SpanishStemmer());
                    }
                };
            }
        }
    }

    public static class Russian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new RussianStemmer());
                    }
                };
            }
        }
    }

    public static class Romanian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new RomanianStemmer());
                    }
                };
            }
        }
    }

    public static class Norwegian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new NorwegianStemmer());
                    }
                };
            }
        }
    }

    public static class Hungarian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new HungarianStemmer());
                    }
                };
            }
        }
    }

    public static class Finnish {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new FinnishStemmer());
                    }
                };
            }
        }
    }

    public static class Dutch {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new DutchStemmer());
                    }
                };
            }
        }
    }

    public static class Danish {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new DanishStemmer());
                    }
                };
            }
        }
    }

    public static class Catalan {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new CatalanStemmer());
                    }
                };
            }
        }
    }

    public static class Basque {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new BasqueStemmer());
                    }
                };
            }
        }
    }

    public static class Armenian {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> aggressive() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(TokenStream input) {
                        return new SnowballFilter(input, (SnowballProgram)new ArmenianStemmer());
                    }
                };
            }
        }
    }

    public static class General {

        public static class Stemming {
            public static Function<TokenStream, TokenStream> none() {
                return new Function<TokenStream, TokenStream>(){

                    public TokenStream apply(@Nullable TokenStream input) {
                        return input;
                    }
                };
            }
        }
    }
}

