/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class StemmingAnalyzer
extends TextAnalyzer {
    private final Version matchVersion;
    private final Set<?> stopWords;
    private final Function<TokenStream, TokenStream> stemmingFilter;

    public StemmingAnalyzer(Version matchVersion, boolean indexing, Set<?> stopWords, Function<TokenStream, TokenStream> stemmingFilter) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWords = stopWords;
        this.stemmingFilter = stemmingFilter;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingFilter.apply((Object)result);
        return result;
    }
}

