/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class GreekAnalyzer
extends TextAnalyzer {
    private final Set<?> stopWords;
    private final Version matchVersion;
    private final Function<TokenStream, TokenStream> stemmingFilter;

    public GreekAnalyzer(Version matchVersion, boolean indexing, Function<TokenStream, TokenStream> stemmingFilter) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stemmingFilter = stemmingFilter;
        this.stopWords = org.apache.lucene.analysis.el.GreekAnalyzer.getDefaultStopSet();
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new GreekLowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingFilter.apply((Object)result);
        return result;
    }
}

