/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class EnglishAnalyzer
extends TextAnalyzer {
    private final Set<?> stopWords;
    private final Version version;
    private final Function<TokenStream, TokenStream> stemmingAlgorithm;

    public EnglishAnalyzer(Version version, boolean indexing, Function<TokenStream, TokenStream> stemmingStrategy) {
        super(indexing);
        this.stemmingAlgorithm = stemmingStrategy;
        this.stopWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        this.version = version;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.version, reader);
        result = new StandardFilter(this.version, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.version, (TokenStream)result);
        result = new StopFilter(this.version, (TokenStream)result, this.stopWords);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = (TokenStream)this.stemmingAlgorithm.apply((Object)result);
        return result;
    }
}

