/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.LuceneVersion;
import com.atlassian.jira.issue.index.analyzer.BrazilianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.BulgarianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CJKAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CzechAnalyzer;
import com.atlassian.jira.issue.index.analyzer.EnglishAnalyzer;
import com.atlassian.jira.issue.index.analyzer.FrenchAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GermanAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GreekAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ItalianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.SimpleAnalyzer;
import com.atlassian.jira.issue.index.analyzer.StemmingAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ThaiAnalyzer;
import com.atlassian.jira.issue.index.analyzer.TokenFilters;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;

public class JiraAnalyzer
extends Analyzer {
    private final boolean indexing;
    private final Stemming stemming;
    private static final Logger log = Logger.getLogger(JiraAnalyzer.class);
    public static final Analyzer ANALYZER_FOR_INDEXING = new PerFieldIndexingAnalyzer();
    public static final Analyzer ANALYZER_FOR_SEARCHING = new JiraAnalyzer(false, Stemming.ON);
    public static final Analyzer ANALYZER_FOR_EXACT_SEARCHING = new JiraAnalyzer(false, Stemming.OFF);
    private final Cache<String, Analyzer> analyzers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Analyzer>(){

        public Analyzer load(String key) throws Exception {
            return JiraAnalyzer.this.makeAnalyzer(key);
        }
    });
    private final Analyzer fallbackAnalyzer;

    public JiraAnalyzer(boolean indexing, Stemming stemming) {
        this.indexing = indexing;
        this.stemming = stemming;
        this.fallbackAnalyzer = new SimpleAnalyzer(LuceneVersion.get(), this.indexing);
    }

    Analyzer makeAnalyzer(String language) {
        if (language.equals("armenian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, ArmenianAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Armenian.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("basque")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, BasqueAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Basque.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("bulgarian")) {
            return new BulgarianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Bulgarian.Stemming.standard() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("brazilian")) {
            return new BrazilianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Portuguese.Brazil.Stemming.standard() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("catalan")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, CatalanAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Catalan.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("chinese")) {
            return new SimpleAnalyzer(LuceneVersion.get(), this.indexing);
        }
        if (language.equals("cjk")) {
            return new CJKAnalyzer(LuceneVersion.get(), this.indexing);
        }
        if (language.equals("czech")) {
            return new CzechAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Czech.Stemming.standard() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("danish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, DanishAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Danish.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("dutch")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, DutchAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Dutch.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("english")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("english-moderate-stemming")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.moderate() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("english-minimal-stemming")) {
            return new EnglishAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.minimal() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("finnish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, FinnishAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Finnish.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("french")) {
            return new FrenchAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.French.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("german")) {
            return new GermanAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.German.Stemming.standard() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("greek")) {
            return new GreekAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Greek.Stemming.standard() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("hungarian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, HungarianAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Hungarian.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("italian")) {
            return new ItalianAnalyzer(LuceneVersion.get(), this.indexing, this.stemming == Stemming.ON ? TokenFilters.Italian.Stemming.agressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("norwegian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, NorwegianAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Norwegian.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("portuguese")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, PortugueseAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Portuguese.Portugal.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("romanian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, RomanianAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Romanian.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("russian")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, RussianAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Russian.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("spanish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, SpanishAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Spanish.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("swedish")) {
            return new StemmingAnalyzer(LuceneVersion.get(), this.indexing, SwedishAnalyzer.getDefaultStopSet(), this.stemming == Stemming.ON ? TokenFilters.Swedish.Stemming.aggressive() : TokenFilters.General.Stemming.none());
        }
        if (language.equals("thai")) {
            return new ThaiAnalyzer(LuceneVersion.get(), this.indexing);
        }
        if (language.equals("other")) {
            return this.fallbackAnalyzer;
        }
        return this.fallbackAnalyzer;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        if (fieldname == null) {
            fieldname = "";
        }
        return this.findAnalyzer().tokenStream(fieldname, reader);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return super.reusableTokenStream(fieldName, reader);
    }

    private Analyzer findAnalyzer() {
        String language = this.getLanguage();
        if (language == null) {
            return this.fallbackAnalyzer;
        }
        Analyzer analyzer = null;
        try {
            analyzer = (Analyzer)this.analyzers.get((Object)language);
        }
        catch (ExecutionException e) {
            log.error((Object)("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'."));
            analyzer = this.fallbackAnalyzer;
        }
        if (analyzer == null) {
            log.error((Object)("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'."));
            analyzer = this.fallbackAnalyzer;
        }
        return analyzer;
    }

    String getLanguage() {
        return ComponentAccessor.getApplicationProperties().getString("jira.i18n.language.index");
    }

    private static class PerFieldIndexingAnalyzer
    extends Analyzer {
        private final Analyzer PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER = new JiraAnalyzer(true, Stemming.OFF);
        private final Analyzer TEXT_FIELD_INDEXING_ANALYZER = new JiraAnalyzer(true, Stemming.ON);

        private PerFieldIndexingAnalyzer() {
        }

        public final TokenStream tokenStream(String fieldName, Reader reader) {
            if (PhraseQuerySupportField.isPhraseQuerySupportField((String)fieldName)) {
                return this.PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER.tokenStream(fieldName, reader);
            }
            return this.TEXT_FIELD_INDEXING_ANALYZER.tokenStream(fieldName, reader);
        }

        public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            if (PhraseQuerySupportField.isPhraseQuerySupportField((String)fieldName)) {
                return this.PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER.reusableTokenStream(fieldName, reader);
            }
            return this.TEXT_FIELD_INDEXING_ANALYZER.reusableTokenStream(fieldName, reader);
        }
    }

    public static enum Stemming {
        ON,
        OFF;

    }
}

