/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.fugue.Option;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;

public class DefaultCommentDocumentFactory
implements CommentDocumentFactory {
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultCommentDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = searchExtractorManager;
    }

    public Option<Document> apply(Comment comment) {
        Date updated;
        ApplicationUser updateAuthor;
        Issue issue = comment.getIssue();
        String body = comment.getBody();
        if (body == null) {
            return Option.none();
        }
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(comment).addField("projid", String.valueOf(issue.getProjectObject().getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("issue_id", String.valueOf(issue.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("id", String.valueOf(comment.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("body", body, Field.Store.YES, Field.Index.ANALYZED)).addField(PhraseQuerySupportField.forIndexField((String)"body"), body, Field.Store.YES, Field.Index.ANALYZED)).addField("comment_created", LuceneUtils.dateToString((Date)comment.getCreated()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addKeywordWithDefault("level", comment.getGroupLevel(), "-1")).addKeywordWithDefault("role_level", comment.getRoleLevel() != null ? comment.getRoleLevel().getId() : null, "-1")).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Comment.class));
        ApplicationUser author = comment.getAuthorApplicationUser();
        if (author != null) {
            builder.addField("comment_author", author.getKey(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        }
        if ((updateAuthor = comment.getUpdateAuthorApplicationUser()) != null) {
            builder.addField("comment_update_author", updateAuthor.getKey(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        }
        if ((updated = comment.getUpdated()) != null) {
            builder.addField("comment_updated", LuceneUtils.dateToString((Date)updated), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        }
        return builder.build();
    }

    @Override
    public Term getIdentifyingTerm(Comment comment) {
        return new Term("id", comment.getId().toString());
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Comment, Builder> {
        private Builder(Comment entity) {
            super(entity, "comments");
        }
    }
}

