/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.fugue.Option;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class DefaultChangeHistoryDocumentFactory
implements ChangeHistoryDocumentFactory {
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultChangeHistoryDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = searchExtractorManager;
    }

    public Option<Document> apply(ChangeHistoryGroup changeHistoryGroup) {
        if (changeHistoryGroup == null) {
            return Option.none();
        }
        String changeItemUser = changeHistoryGroup.getUserKey();
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(changeHistoryGroup).addField("projid", String.valueOf(changeHistoryGroup.getProjectId()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("issue_id", String.valueOf(changeHistoryGroup.getIssueId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("key", String.valueOf(changeHistoryGroup.getIssueKey()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("ch_who", DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(changeItemUser), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("ch_date", LuceneUtils.dateToString((Date)changeHistoryGroup.getCreated()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(ChangeHistoryGroup.class));
        for (ChangeHistoryItem changeItem : changeHistoryGroup.getChangeItems()) {
            String changedField = changeItem.getField();
            ((Builder)builder.addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_duration"), String.valueOf(changeItem.getDuration()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_nextchangedate"), LuceneUtils.dateToString((Date)changeItem.getNextChangeCreated()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            for (String from : changeItem.getFroms().values()) {
                builder.addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_from"), DefaultChangeHistoryDocumentFactory.encodeProtocol(from), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
            for (String to : changeItem.getTos().values()) {
                builder.addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_to"), DefaultChangeHistoryDocumentFactory.encodeProtocol(to), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
            for (String fromValue : changeItem.getFroms().keySet()) {
                builder.addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_oldvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(fromValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
            for (String toValue : changeItem.getTos().keySet()) {
                builder.addField(DefaultChangeHistoryDocumentFactory.encodeChangedField(changedField, "ch_newvalue"), DefaultChangeHistoryDocumentFactory.encodeProtocolPreservingCase(toValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
        }
        return builder.build();
    }

    private static String encodeChangedField(String changedField, String docConstant) {
        return changedField + '.' + docConstant;
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }

    private static String encodeProtocolPreservingCase(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem);
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<ChangeHistoryGroup, Builder> {
        private Builder(ChangeHistoryGroup entity) {
            super(entity, "changes");
        }
    }
}

