/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.AbstractDateRangeBuilder;
import com.atlassian.jira.issue.priority.Priority;
import org.apache.log4j.Logger;

public class PriorityDateRangeBuilder
extends AbstractDateRangeBuilder {
    private static final Logger log = Logger.getLogger(PriorityDateRangeBuilder.class);
    private static final String EMPTY_VALUE = "-1";

    public PriorityDateRangeBuilder() {
        this("priority", EMPTY_VALUE);
    }

    public PriorityDateRangeBuilder(String field, String emptyValue) {
        super(field, emptyValue);
    }

    @Override
    protected ChangeHistoryItem createInitialChangeItem(Issue issue) {
        Priority priority = issue.getPriorityObject();
        String priorityName = priority == null ? EMPTY_VALUE : priority.getName();
        String priorityValue = priority == null ? EMPTY_VALUE : priority.getId();
        return this.changeItemBuilder(issue).to(priorityName, priorityValue).build();
    }
}

