/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.BulkFieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.screen.StandardFieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.List;

public class FieldScreenRendererFactoryImpl
implements FieldScreenRendererFactory {
    private final BulkFieldScreenRendererFactory bulkRendererFactory;
    private final StandardFieldScreenRendererFactory rendererFactory;

    public FieldScreenRendererFactoryImpl(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager, HackyFieldRendererRegistry hackyFieldRendererRegistry) {
        this(new BulkFieldScreenRendererFactory(fieldManager, fieldLayoutManager, hackyFieldRendererRegistry), new StandardFieldScreenRendererFactory(fieldManager, fieldLayoutManager, issueTypeScreenSchemeManager, fieldScreenManager));
    }

    FieldScreenRendererFactoryImpl(BulkFieldScreenRendererFactory bulkRendererFactory, StandardFieldScreenRendererFactory rendererFactory) {
        this.bulkRendererFactory = bulkRendererFactory;
        this.rendererFactory = rendererFactory;
    }

    public FieldScreenRenderer getFieldScreenRenderer(Issue issue, IssueOperation issueOperation) {
        return this.getFieldScreenRenderer(issue, issueOperation, (Predicate<? super Field>)Predicates.truePredicate());
    }

    public FieldScreenRenderer getFieldScreenRenderer(Issue issue, IssueOperation issueOperation, Predicate<? super Field> predicate) {
        return this.rendererFactory.createFieldScreenRenderer(issue, issueOperation, predicate);
    }

    public FieldScreenRenderer getFieldScreenRenderer(User remoteUser, Issue issue, IssueOperation issueOperation, boolean onlyShownCustomFields) {
        return this.getFieldScreenRenderer(issue, issueOperation, (Predicate<? super Field>)(onlyShownCustomFields ? FieldPredicates.isCustomField() : Predicates.truePredicate()));
    }

    public FieldScreenRenderer getFieldScreenRenderer(User remoteUser, Issue issue, IssueOperation issueOperation, Predicate<? super Field> predicate) {
        return this.rendererFactory.createFieldScreenRenderer(issue, issueOperation, predicate);
    }

    public FieldScreenRenderer getFieldScreenRenderer(User remoteUser, Issue issue, ActionDescriptor actionDescriptor) {
        return this.rendererFactory.createFieldScreenRenderer(issue, actionDescriptor);
    }

    public FieldScreenRenderer getFieldScreenRenderer(Issue issue, ActionDescriptor actionDescriptor) {
        return this.rendererFactory.createFieldScreenRenderer(issue, actionDescriptor);
    }

    public FieldScreenRenderer getFieldScreenRenderer(Issue issue) {
        return this.rendererFactory.createFieldScreenRenderer(issue);
    }

    public FieldScreenRenderer getFieldScreenRenderer(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        return this.bulkRendererFactory.createRenderer(issues, actionDescriptor);
    }

    public FieldScreenRenderer getFieldScreenRenderer(List<String> fieldIds, User remoteUser, Issue issue, IssueOperation issueOperation) {
        return this.rendererFactory.createFieldScreenRenderer(fieldIds, issue, issueOperation);
    }
}

