/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;

public class FieldHtmlFactoryImpl
implements FieldHtmlFactory {
    private static final Map<String, Object> DISPLAY_PARAMS = MapBuilder.newBuilder((Object)"noHeader", (Object)"true", (Object)"theme", (Object)"aui", (Object)"isFirstField", (Object)true, (Object)"isLastField", (Object)true).toMutableMap();
    private final I18nHelper.BeanFactory beanFactory;
    private final FieldManager fieldManager;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private final PermissionManager permissionManager;

    public FieldHtmlFactoryImpl(I18nHelper.BeanFactory beanFactory, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, PermissionManager permissionManager) {
        this.beanFactory = beanFactory;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.permissionManager = permissionManager;
    }

    public List<FieldHtmlBean> getCreateFields(User user, OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain) {
        List<FieldHtmlBean> ret = this.createProjectAndIssueTypeFields(operationContext, action, newIssueObject);
        List<FieldRenderItemWithTab> items = this.getRenderableItems((Issue)newIssueObject, IssueOperations.CREATE_ISSUE_OPERATION);
        for (FieldRenderItemWithTab item : items) {
            FieldScreenRenderLayoutItem fsrli = item.getFieldScreenRenderLayoutItem();
            String fieldId = fsrli.getOrderableField().getId();
            if (retainValues && fieldsToRetain.contains(fieldId)) {
                fsrli.getOrderableField().populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
                continue;
            }
            if (fieldsToRetain != null && fieldsToRetain.contains(fieldId) && !fieldId.equals("attachment")) continue;
            operationContext.getFieldValuesHolder().remove(fieldId);
            fsrli.populateDefaults(operationContext.getFieldValuesHolder(), (Issue)newIssueObject);
        }
        I18nHelper i18nHelper = this.beanFactory.getInstance(user);
        for (FieldRenderItemWithTab item : items) {
            FieldScreenRenderLayoutItem frli = item.getFieldScreenRenderLayoutItem();
            String createHtml = frli.getCreateHtml(action, operationContext, (Issue)newIssueObject, DISPLAY_PARAMS);
            if (!StringUtils.isNotBlank((String)createHtml)) continue;
            Object defaultValue = frli.getFieldLayoutItem().getOrderableField().getDefaultValue((Issue)newIssueObject);
            boolean isRequired = false;
            if (defaultValue == null && frli.isRequired()) {
                isRequired = true;
            }
            ret.add(new FieldHtmlBean(frli.getFieldLayoutItem().getOrderableField().getId(), i18nHelper.getText(frli.getFieldLayoutItem().getOrderableField().getNameKey()), isRequired, createHtml.trim(), item.getFieldTab()));
        }
        return ret;
    }

    public List<FieldHtmlBean> getEditFields(User user, OperationContext operationContext, Action action, Issue issue, boolean retainValues) {
        ArrayList<FieldHtmlBean> ret = new ArrayList<FieldHtmlBean>();
        List<FieldRenderItemWithTab> items = this.getRenderableItems(issue, IssueOperations.EDIT_ISSUE_OPERATION);
        for (FieldRenderItemWithTab item : items) {
            FieldScreenRenderLayoutItem fsrli = item.getFieldScreenRenderLayoutItem();
            if (retainValues) {
                fsrli.getOrderableField().populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
                continue;
            }
            fsrli.populateFromIssue(operationContext.getFieldValuesHolder(), issue);
        }
        I18nHelper i18nHelper = this.beanFactory.getInstance(user);
        FieldTab firstTab = null;
        for (FieldRenderItemWithTab item : items) {
            FieldScreenRenderLayoutItem fsrli;
            String editHtml;
            FieldTab currentTab = item.getFieldTab();
            if (firstTab == null && currentTab.getPosition() == 0) {
                firstTab = currentTab;
            }
            if (!StringUtils.isNotBlank((String)(editHtml = (fsrli = item.getFieldScreenRenderLayoutItem()).getEditHtml(action, operationContext, issue, DISPLAY_PARAMS)))) continue;
            ret.add(new FieldHtmlBean(fsrli.getFieldLayoutItem().getOrderableField().getId(), i18nHelper.getText(fsrli.getFieldLayoutItem().getOrderableField().getNameKey()), fsrli.isRequired(), editHtml.trim(), currentTab));
        }
        if (this.permissionManager.hasPermission(15, issue, user)) {
            CommentSystemField commentField = (CommentSystemField)this.fieldManager.getField("comment");
            if (retainValues) {
                commentField.populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
            }
            FieldLayoutItem commentFieldLayoutItem = this.getFieldScreenRenderer(issue, IssueOperations.EDIT_ISSUE_OPERATION).getFieldScreenRenderLayoutItem((OrderableField)commentField).getFieldLayoutItem();
            ret.add(new FieldHtmlBean(commentField.getId(), commentField.getName(), false, commentField.getEditHtml(commentFieldLayoutItem, operationContext, action, issue, DISPLAY_PARAMS), firstTab));
        }
        return ret;
    }

    public List<FieldHtmlBean> getSubTaskCreateFields(User user, OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain) {
        return this.getCreateFields(user, operationContext, action, newIssueObject, retainValues, fieldsToRetain);
    }

    private List<FieldHtmlBean> createProjectAndIssueTypeFields(OperationContext operationContext, Action action, MutableIssue newIssueObject) {
        ArrayList<FieldHtmlBean> ret = new ArrayList<FieldHtmlBean>();
        ProjectSystemField projectField = (ProjectSystemField)this.fieldManager.getField("project");
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.fieldManager.getField("issuetype");
        projectField.updateIssue(null, newIssueObject, operationContext.getFieldValuesHolder());
        issueTypeField.updateIssue(null, newIssueObject, operationContext.getFieldValuesHolder());
        ret.add(new FieldHtmlBean(projectField.getId(), projectField.getName(), true, projectField.getCreateHtml(null, operationContext, action, (Issue)newIssueObject, DISPLAY_PARAMS), null));
        ret.add(new FieldHtmlBean(issueTypeField.getId(), issueTypeField.getName(), true, issueTypeField.getCreateHtml(null, operationContext, action, (Issue)newIssueObject, DISPLAY_PARAMS), null));
        return ret;
    }

    private List<FieldRenderItemWithTab> getRenderableItems(Issue issue, ScreenableIssueOperation operation) {
        ArrayList<FieldRenderItemWithTab> items = new ArrayList<FieldRenderItemWithTab>();
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(issue, operation);
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            FieldTab currentTab = new FieldTab(fieldScreenRenderTab.getName(), fieldScreenRenderTab.getPosition());
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                boolean excludeIssueType;
                String fieldId = fieldScreenRenderLayoutItem.getOrderableField().getId();
                boolean bl = excludeIssueType = operation.equals(IssueOperations.CREATE_ISSUE_OPERATION) && "issuetype".equals(fieldId);
                if ("project".equals(fieldId) || excludeIssueType || !fieldScreenRenderLayoutItem.isShow(issue)) continue;
                items.add(new FieldRenderItemWithTab(fieldScreenRenderLayoutItem, currentTab));
            }
        }
        return items;
    }

    private FieldScreenRenderer getFieldScreenRenderer(Issue issue, ScreenableIssueOperation operation) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)operation);
    }

    private static class FieldRenderItemWithTab {
        private FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem;
        private FieldTab fieldTab;

        private FieldRenderItemWithTab(FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, FieldTab fieldTab) {
            this.fieldScreenRenderLayoutItem = fieldScreenRenderLayoutItem;
            this.fieldTab = fieldTab;
        }

        public FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem() {
            return this.fieldScreenRenderLayoutItem;
        }

        public FieldTab getFieldTab() {
            return this.fieldTab;
        }
    }
}

