/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.TransformedKeyCache;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.OptionSetManagerImpl;
import com.atlassian.jira.issue.fields.option.OptionSetPersister;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Function;
import java.util.Collection;
import javax.annotation.Nonnull;

@EventComponent
public class CachedOptionSetManager
implements OptionSetManager {
    private static final int MAX_ENTRIES = 512;
    private final Cache<FieldConfig, OptionSet> cache;
    private final OptionSetManagerImpl optionSetManager;

    public CachedOptionSetManager(OptionSetPersister optionSetPersister, ConstantsManager constantsManager, CacheManager cacheManager) {
        this.optionSetManager = new OptionSetManagerImpl(optionSetPersister, constantsManager);
        Cache cache = cacheManager.getCache(CachedOptionSetManager.class.getName() + ".cache", null, new CacheSettingsBuilder().maxEntries(1000).build());
        this.cache = TransformedKeyCache.transform(cache, new KeyFromFieldConfig(), new OptionSetLoader());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    public OptionSet getOptionsForConfig(@Nonnull FieldConfig config) {
        return (OptionSet)this.cache.get(Assertions.notNull((String)"config", (Object)config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet createOptionSet(@Nonnull FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.createOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionSet updateOptionSet(@Nonnull FieldConfig config, Collection optionIds) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            OptionSet optionSet = this.optionSetManager.updateOptionSet(config, optionIds);
            return optionSet;
        }
        finally {
            this.cache.remove((Object)config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOptionSet(@Nonnull FieldConfig config) {
        Assertions.notNull((String)"config", (Object)config);
        try {
            this.optionSetManager.removeOptionSet(config);
        }
        finally {
            this.cache.remove((Object)config);
        }
    }

    static class KeyFromFieldConfig
    implements Function<FieldConfig, Long> {
        KeyFromFieldConfig() {
        }

        public Long get(FieldConfig fieldConfig) {
            return fieldConfig.getId();
        }
    }

    class OptionSetLoader
    implements CacheLoader<FieldConfig, OptionSet> {
        OptionSetLoader() {
        }

        public OptionSet load(FieldConfig fieldConfig) {
            return CachedOptionSetManager.this.optionSetManager.getOptionsForConfig(fieldConfig);
        }
    }
}

