/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeAddedToProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCopiedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeDeletedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityRemovedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityUpdatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.AbstractFieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntityImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeImpl;
import com.atlassian.jira.issue.fields.layout.field.enterprise.ImmutableFieldConfigurationScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultFieldLayoutManager
extends AbstractFieldLayoutManager
implements FieldLayoutManager {
    private static final String PROJECT_ENTITY_NAME = "Project";
    private static final String FIELD_LAYOUT_SCHEME_ASSOCIATION = "FieldLayoutScheme";
    private static final NodeAssocationType NODE_ASSOCATION_TYPE = new NodeAssocationType("ProjectScheme", "Project", "FieldLayoutScheme");
    private static final Logger log = Logger.getLogger(DefaultFieldLayoutManager.class);
    private final Cache<Long, CacheObject<Long>> fieldSchemeCache;
    private final Cache<Long, ImmutableFieldConfigurationScheme> fieldConfigurationSchemeCache;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final ProjectManager projectManager;
    private final EventPublisher eventPublisher;
    private final NodeAssociationStore nodeAssociationStore;

    public DefaultFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, SubTaskManager subTaskManager, ProjectManager projectManager, I18nHelper.BeanFactory i18n, NodeAssociationStore nodeAssociationStore, CacheManager cacheManager, EventPublisher eventPublisher) {
        super(fieldManager, ofBizDelegator, i18n, cacheManager);
        this.projectManager = projectManager;
        this.eventPublisher = eventPublisher;
        this.constantsManager = (ConstantsManager)Assertions.notNull((String)"constantsManager", (Object)constantsManager);
        this.subTaskManager = (SubTaskManager)Assertions.notNull((String)"subTaskManager", (Object)subTaskManager);
        this.nodeAssociationStore = nodeAssociationStore;
        this.fieldSchemeCache = cacheManager.getCache(DefaultFieldLayoutManager.class.getName() + ".fieldSchemeCache", (CacheLoader)new FieldSchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.fieldConfigurationSchemeCache = cacheManager.getCache(DefaultFieldLayoutManager.class.getName() + ".fieldConfigurationSchemeCache", (CacheLoader)new ConfigurationSchemeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public FieldLayout getFieldLayout(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("GenericValue must be an issue. It is a(n) " + issue.getEntityName() + ".");
        }
        return this.getFieldLayout(JiraEntityUtils.getProject(issue), issue.getString("type"));
    }

    public FieldLayout getFieldLayout(Project project, String issueTypeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null.");
        }
        FieldConfigurationScheme fieldConfigurationScheme = this.getFieldConfigurationScheme(project);
        if (fieldConfigurationScheme != null) {
            Long fieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(issueTypeId);
            return this.getRelevantFieldLayout(fieldLayoutId);
        }
        return this.getFieldLayout();
    }

    public FieldLayout getFieldLayout(GenericValue project, String issueTypeId) {
        if (project == null) {
            throw new IllegalArgumentException("Generic Value cannot be null.");
        }
        if (!PROJECT_ENTITY_NAME.equals(project.getEntityName())) {
            throw new IllegalArgumentException("Generic Value must be a Project - '" + project.getEntityName() + "' is not.");
        }
        FieldConfigurationScheme fieldConfigurationScheme = this.getFieldConfigurationScheme(project);
        if (fieldConfigurationScheme != null) {
            Long fieldLayoutId = fieldConfigurationScheme.getFieldLayoutId(issueTypeId);
            return this.getRelevantFieldLayout(fieldLayoutId);
        }
        return this.getFieldLayout();
    }

    private ImmutableFieldConfigurationScheme buildFieldConfigurationScheme(GenericValue fieldLayoutSchemeGV) {
        Assertions.notNull((String)"fieldLayoutSchemeGV", (Object)fieldLayoutSchemeGV);
        Collection<GenericValue> schemeEntities = this.getFieldLayoutSchemeEntityGVs(fieldLayoutSchemeGV.getLong("id"));
        return new ImmutableFieldConfigurationScheme(fieldLayoutSchemeGV, schemeEntities);
    }

    private Collection<GenericValue> getFieldLayoutSchemeEntityGVs(Long fieldLayoutSchemeId) {
        try {
            return this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutSchemeId);
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    public List<FieldLayoutScheme> getFieldLayoutSchemes() {
        LinkedList<FieldLayoutScheme> fieldLayoutSchemes = new LinkedList<FieldLayoutScheme>();
        List fieldLayoutSchemeGVs = this.ofBizDelegator.findAll(FIELD_LAYOUT_SCHEME_ASSOCIATION, Collections.singletonList("name ASC"));
        for (GenericValue fieldLayoutSchemeGV : fieldLayoutSchemeGVs) {
            fieldLayoutSchemes.add(this.buildFieldLayoutScheme(fieldLayoutSchemeGV));
        }
        return fieldLayoutSchemes;
    }

    public Collection<GenericValue> getRelatedProjects(FieldLayout fieldLayout) {
        ArrayList<GenericValue> relatedProjects = new ArrayList<GenericValue>();
        for (FieldConfigurationScheme fieldConfigurationScheme : this.getFieldConfigurationSchemes(fieldLayout)) {
            relatedProjects.addAll(this.getProjects(fieldConfigurationScheme));
        }
        if (fieldLayout.isDefault()) {
            relatedProjects.addAll(this.getProjects((FieldConfigurationScheme)null));
        }
        return relatedProjects;
    }

    public List<EditableFieldLayout> getEditableFieldLayouts() {
        LinkedList<EditableFieldLayout> fieldLayouts = new LinkedList<EditableFieldLayout>();
        fieldLayouts.add((EditableFieldLayout)this.getEditableDefaultFieldLayout());
        List fieldLayoutGVs = this.ofBizDelegator.findByField("FieldLayout", "type", null, "name");
        for (GenericValue editableFieldLayoutGV : fieldLayoutGVs) {
            FieldLayout fieldLayout = this.getRelevantFieldLayout(editableFieldLayoutGV.getLong("id"));
            fieldLayouts.add((EditableFieldLayout)new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems()));
        }
        return fieldLayouts;
    }

    public EditableFieldLayout getEditableFieldLayout(Long id) {
        FieldLayout fieldLayout = this.getRelevantFieldLayout(id);
        return new EditableFieldLayoutImpl(fieldLayout.getGenericValue(), fieldLayout.getFieldLayoutItems());
    }

    public void updateFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        if (!TextUtils.stringSet((String)fieldLayoutScheme.getName())) {
            throw new IllegalArgumentException("Name passed must not be null.");
        }
        try {
            FieldLayoutScheme originalScheme = this.getMutableFieldLayoutScheme(fieldLayoutScheme.getId());
            this.clearCaches();
            fieldLayoutScheme.getGenericValue().store();
            if (fieldLayoutScheme.getEntities() != null) {
                for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : fieldLayoutScheme.getEntities()) {
                    fieldLayoutSchemeEntity.store();
                }
            }
            this.eventPublisher.publish((Object)new FieldLayoutSchemeUpdatedEvent(fieldLayoutScheme, originalScheme));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            this.nodeAssociationStore.removeAssociationsFromSink(fieldLayoutScheme.getGenericValue());
            fieldLayoutScheme.getGenericValue().remove();
            this.refresh();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeDeletedEvent(fieldLayoutScheme.getId(), fieldLayoutScheme.getName()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteFieldLayout(FieldLayout fieldLayout) {
        try {
            GenericValue genericValue = fieldLayout.getGenericValue();
            if (genericValue != null) {
                genericValue.removeRelated("ChildFieldLayoutItem");
                genericValue.remove();
            }
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeEntities(FieldLayoutScheme fieldLayoutScheme) {
        try {
            LinkedList<FieldLayoutSchemeEntity> fieldLayoutSchemeEntities = new LinkedList<FieldLayoutSchemeEntity>();
            List fieldLayoutSchemeEntityGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "scheme", (Object)fieldLayoutScheme.getId());
            for (GenericValue fieldLayoutSchemeEntityGV : fieldLayoutSchemeEntityGVs) {
                FieldLayoutSchemeEntityImpl fieldLayoutSchemeEntity = new FieldLayoutSchemeEntityImpl(this, fieldLayoutSchemeEntityGV, ComponentAccessor.getConstantsManager());
                fieldLayoutSchemeEntity.setFieldLayoutScheme(fieldLayoutScheme);
                fieldLayoutSchemeEntities.add(fieldLayoutSchemeEntity);
            }
            return fieldLayoutSchemeEntities;
        }
        catch (DataAccessException e) {
            throw new DataAccessException("Error occurred while retrieving field layout scheme entities from the database.", (Throwable)e);
        }
    }

    public void createFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        this.createFieldLayoutSchemeEntity(fieldLayoutSchemeEntity.getFieldLayoutScheme(), fieldLayoutSchemeEntity.getIssueTypeId(), fieldLayoutSchemeEntity.getFieldLayoutId());
    }

    public void updateFieldLayoutSchemeEntity(final FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        Option originalEntity = Iterables.first((Iterable)Collections2.filter(this.getFieldLayoutSchemeEntities(fieldLayoutSchemeEntity.getFieldLayoutScheme()), (Predicate)new Predicate<FieldLayoutSchemeEntity>(){

            public boolean apply(@Nullable FieldLayoutSchemeEntity input) {
                return StringUtils.equals((CharSequence)input.getIssueTypeId(), (CharSequence)fieldLayoutSchemeEntity.getIssueTypeId());
            }
        }));
        try {
            fieldLayoutSchemeEntity.getGenericValue().store();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityUpdatedEvent(fieldLayoutSchemeEntity.getFieldLayoutScheme(), (FieldLayoutSchemeEntity)originalEntity.getOrElse((Object)fieldLayoutSchemeEntity), fieldLayoutSchemeEntity));
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while persisting field layout scheme entity.", (Throwable)e);
        }
    }

    protected void removeFieldLayoutSchemeEntityNoEvent(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        try {
            FieldLayoutScheme fieldLayoutScheme = fieldLayoutSchemeEntity.getFieldLayoutScheme();
            ((FieldLayoutSchemeImpl)fieldLayoutScheme).flushEntity(fieldLayoutSchemeEntity);
            fieldLayoutSchemeEntity.setFieldLayoutScheme(null);
            fieldLayoutSchemeEntity.getGenericValue().remove();
            this.clearCaches();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while removing field layout scheme entity.", (Throwable)e);
        }
    }

    public void removeFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        FieldLayoutScheme scheme = fieldLayoutSchemeEntity.getFieldLayoutScheme();
        this.removeFieldLayoutSchemeEntityNoEvent(fieldLayoutSchemeEntity);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityRemovedEvent(scheme, fieldLayoutSchemeEntity));
    }

    public void removeFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        try {
            for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : fieldLayoutScheme.getEntities()) {
                this.removeFieldLayoutSchemeEntityNoEvent(fieldLayoutSchemeEntity);
            }
            fieldLayoutScheme.getGenericValue().remove();
            this.clearCaches();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeDeletedEvent(fieldLayoutScheme.getId(), fieldLayoutScheme.getName()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<FieldConfigurationScheme> getFieldConfigurationSchemes(FieldLayout fieldLayout) {
        Long id = fieldLayout.isDefault() ? null : fieldLayout.getId();
        HashSet<Long> fieldLayoutSchemeIds = new HashSet<Long>();
        List fieldLayoutSchemeEntitiyGVs = this.ofBizDelegator.findByField("FieldLayoutSchemeEntity", "fieldlayout", (Object)id);
        for (GenericValue fieldLayoutSchemeEntitiyGV : fieldLayoutSchemeEntitiyGVs) {
            fieldLayoutSchemeIds.add(fieldLayoutSchemeEntitiyGV.getLong("scheme"));
        }
        HashSet<FieldConfigurationScheme> fieldConfigurationSchemes = new HashSet<FieldConfigurationScheme>(fieldLayoutSchemeIds.size());
        for (Long schemeId : fieldLayoutSchemeIds) {
            fieldConfigurationSchemes.add(this.getFieldConfigurationScheme(schemeId));
        }
        return fieldConfigurationSchemes;
    }

    public void restoreSchemeFieldLayout(GenericValue scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme passed must not be null.");
        }
        this.restoreFieldLayout(scheme.getLong("id"));
    }

    public Collection<GenericValue> getProjects(FieldConfigurationScheme fieldConfigurationScheme) {
        if (fieldConfigurationScheme == null) {
            return this.getProjectsWithDefaultFieldConfigurationScheme();
        }
        GenericValue fieldConfigurationSchemeGV = this.makeFieldLayoutSchemeGenericValue(fieldConfigurationScheme.getId());
        return this.nodeAssociationStore.getSourcesFromSink(fieldConfigurationSchemeGV, PROJECT_ENTITY_NAME, "ProjectScheme");
    }

    private Collection<GenericValue> getProjectsWithDefaultFieldConfigurationScheme() {
        ArrayList<GenericValue> projects = new ArrayList<GenericValue>();
        for (GenericValue project : this.projectManager.getProjects()) {
            if (this.getFieldConfigurationScheme(project) != null) continue;
            projects.add(project);
        }
        return projects;
    }

    public Collection<GenericValue> getProjects(FieldLayoutScheme fieldLayoutScheme) {
        return this.nodeAssociationStore.getSourcesFromSink(fieldLayoutScheme.getGenericValue(), PROJECT_ENTITY_NAME, "ProjectScheme");
    }

    public FieldLayoutScheme createFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        return this.createFieldLayoutScheme(fieldLayoutScheme.getName(), fieldLayoutScheme.getDescription());
    }

    public FieldLayoutScheme createFieldLayoutScheme(@Nonnull String name, @Nullable String description) {
        FieldLayoutScheme fieldLayoutScheme = this.createFieldLayoutSchemeNoEvent(name, description);
        this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, null, null);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeCreatedEvent(fieldLayoutScheme));
        return fieldLayoutScheme;
    }

    public FieldLayoutSchemeEntity createFieldLayoutSchemeEntity(@Nonnull FieldLayoutScheme fieldLayoutScheme, @Nullable String issueTypeId, @Nullable Long fieldLayoutId) {
        FieldLayoutSchemeEntity entity = this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, issueTypeId, fieldLayoutId);
        this.eventPublisher.publish((Object)new FieldLayoutSchemeEntityCreatedEvent(fieldLayoutScheme, entity));
        return entity;
    }

    protected FieldLayoutSchemeEntity createFieldLayoutSchemeEntityNoEvent(@Nonnull FieldLayoutScheme fieldLayoutScheme, @Nullable String issueTypeId, @Nullable Long fieldLayoutId) {
        FieldLayoutSchemeEntityImpl entity = new FieldLayoutSchemeEntityImpl(this, null, ComponentAccessor.getConstantsManager());
        entity.setIssueTypeId(issueTypeId);
        entity.setFieldLayoutId(fieldLayoutId);
        entity.setFieldLayoutScheme(fieldLayoutScheme);
        GenericValue fieldLayoutSchemeEntityGV = EntityUtils.createValue("FieldLayoutSchemeEntity", MapBuilder.build((Object)"scheme", (Object)fieldLayoutScheme.getId(), (Object)"issuetype", (Object)issueTypeId, (Object)"fieldlayout", (Object)fieldLayoutId));
        entity.setGenericValue(fieldLayoutSchemeEntityGV);
        this.clearCaches();
        ((FieldLayoutSchemeImpl)fieldLayoutScheme).cacheEntity(entity);
        return entity;
    }

    private FieldLayoutScheme createFieldLayoutSchemeNoEvent(String name, String description) {
        FieldLayoutSchemeImpl fieldLayoutScheme = new FieldLayoutSchemeImpl(this, null);
        fieldLayoutScheme.setName(name);
        fieldLayoutScheme.setDescription(description);
        GenericValue genericValue = EntityUtils.createValue(FIELD_LAYOUT_SCHEME_ASSOCIATION, (Map<String, Object>)FieldMap.build((String)"name", (Object)fieldLayoutScheme.getName(), (String)"description", (Object)fieldLayoutScheme.getDescription()));
        fieldLayoutScheme.setGenericValue(genericValue);
        return fieldLayoutScheme;
    }

    public FieldLayoutScheme copyFieldLayoutScheme(@Nonnull FieldLayoutScheme scheme, @Nonnull String name, @Nullable String description) {
        FieldLayoutScheme fieldLayoutScheme = this.createFieldLayoutSchemeNoEvent(name, description);
        for (FieldLayoutSchemeEntity fieldLayoutSchemeEntity : scheme.getEntities()) {
            this.createFieldLayoutSchemeEntityNoEvent(fieldLayoutScheme, fieldLayoutSchemeEntity.getIssueTypeId(), fieldLayoutSchemeEntity.getFieldLayoutId());
        }
        this.eventPublisher.publish((Object)new FieldLayoutSchemeCopiedEvent(scheme, fieldLayoutScheme));
        return fieldLayoutScheme;
    }

    private FieldLayoutScheme buildFieldLayoutScheme(GenericValue genericValue) {
        if (genericValue != null) {
            return new FieldLayoutSchemeImpl(this, genericValue);
        }
        return null;
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Long schemeId) {
        return (FieldConfigurationScheme)this.fieldConfigurationSchemeCache.get((Object)schemeId);
    }

    public FieldLayoutScheme getMutableFieldLayoutScheme(Long schemeId) {
        return this.buildFieldLayoutScheme(this.ofBizDelegator.findById(FIELD_LAYOUT_SCHEME_ASSOCIATION, schemeId));
    }

    public boolean fieldConfigurationSchemeExists(String schemeName) {
        return !this.ofBizDelegator.findByField(FIELD_LAYOUT_SCHEME_ASSOCIATION, "name", (Object)schemeName).isEmpty();
    }

    public Set<FieldLayout> getUniqueFieldLayouts(Project project) {
        HashSet<FieldLayout> uniqueLayouts = new HashSet<FieldLayout>();
        FieldConfigurationScheme scheme = this.getFieldConfigurationScheme(project.getGenericValue());
        if (scheme != null) {
            for (Long layoutId : scheme.getAllFieldLayoutIds((Collection)this.constantsManager.getAllIssueTypeIds())) {
                FieldLayout fieldLayout = this.getFieldLayout(layoutId);
                if (fieldLayout == null) continue;
                uniqueLayouts.add(fieldLayout);
            }
        } else {
            uniqueLayouts.add(this.getFieldLayout());
        }
        return uniqueLayouts;
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        return this.getFieldConfigurationScheme(project.getGenericValue());
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(GenericValue project) {
        if (project == null) {
            log.error((Object)"Project passed must not be null.");
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        CacheObject cacheObject = (CacheObject)this.fieldSchemeCache.get((Object)project.getLong("id"));
        if (cacheObject.getValue() != null) {
            return this.getFieldConfigurationScheme((Long)cacheObject.getValue());
        }
        return null;
    }

    public void addSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        this.addSchemeAssociation(this.projectManager.getProjectObj(project.getLong("id")), fieldLayoutSchemeId);
    }

    public void addSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        FieldConfigurationScheme oldScheme = this.getFieldConfigurationScheme(project);
        if (oldScheme != null) {
            this.removeSchemeAssociation(project, oldScheme.getId());
        }
        if (fieldLayoutSchemeId != null) {
            this.nodeAssociationStore.createAssociation(NODE_ASSOCATION_TYPE, project.getId(), fieldLayoutSchemeId);
            this.clearCaches();
            this.eventPublisher.publish((Object)new FieldLayoutSchemeAddedToProjectEvent(this.getMutableFieldLayoutScheme(fieldLayoutSchemeId), project));
        }
    }

    private GenericValue makeFieldLayoutSchemeGenericValue(Long fieldLayoutSchemeId) {
        GenericValue gvFieldLayoutScheme = this.ofBizDelegator.makeValue(FIELD_LAYOUT_SCHEME_ASSOCIATION);
        gvFieldLayoutScheme.set("id", (Object)fieldLayoutSchemeId);
        return gvFieldLayoutScheme;
    }

    public void removeSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null.");
        }
        this.removeSchemeAssociation(this.projectManager.getProjectObj(project.getLong("id")), fieldLayoutSchemeId);
    }

    public void removeSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        this.nodeAssociationStore.removeAssociation(NODE_ASSOCATION_TYPE, project.getId(), fieldLayoutSchemeId);
        this.clearCaches();
        FieldLayoutScheme mutableFieldLayoutScheme = this.getMutableFieldLayoutScheme(fieldLayoutSchemeId);
        if (mutableFieldLayoutScheme != null) {
            this.eventPublisher.publish((Object)new FieldLayoutSchemeRemovedFromProjectEvent(mutableFieldLayoutScheme, project));
        }
    }

    public FieldLayout getFieldLayout(Long id) {
        return this.getRelevantFieldLayout(id);
    }

    @Override
    public void refresh() {
        this.clearCaches();
        super.refresh();
    }

    protected void clearCaches() {
        this.fieldSchemeCache.removeAll();
        this.fieldConfigurationSchemeCache.removeAll();
    }

    public boolean isFieldLayoutSchemesVisiblyEquivalent(Long fieldConfigurationSchemeId1, Long fieldConfigurationSchemeId2) {
        if (fieldConfigurationSchemeId1 == null && fieldConfigurationSchemeId2 == null) {
            return true;
        }
        FieldConfigurationScheme scheme1 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId1);
        FieldConfigurationScheme scheme2 = this.getNotNullFieldConfigurationScheme(fieldConfigurationSchemeId2);
        for (String issueType : this.getAllRelevantIssueTypeIds()) {
            if (this.isFieldLayoutsVisiblyEquivalent(scheme1.getFieldLayoutId(issueType), scheme2.getFieldLayoutId(issueType))) continue;
            return false;
        }
        return true;
    }

    private FieldConfigurationScheme getNotNullFieldConfigurationScheme(Long fieldConfigurationSchemeId) {
        if (fieldConfigurationSchemeId == null) {
            return new DefaultFieldConfigurationScheme();
        }
        return this.getFieldConfigurationScheme(fieldConfigurationSchemeId);
    }

    public boolean isFieldLayoutsVisiblyEquivalent(Long fieldLayoutId1, Long fieldLayoutId2) {
        Map<String, Boolean> map1 = this.createFieldIdToVisibilityMap(fieldLayoutId1);
        Map<String, Boolean> map2 = this.createFieldIdToVisibilityMap(fieldLayoutId2);
        return ((Object)map1).equals(map2);
    }

    private Map<String, Boolean> createFieldIdToVisibilityMap(Long fieldLayoutId) {
        FieldLayout fieldLayout = this.getFieldLayout(fieldLayoutId);
        List list = fieldLayout.getFieldLayoutItems();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (FieldLayoutItem item : list) {
            map.put(item.getOrderableField().getId(), item.isHidden());
        }
        return map;
    }

    protected List<String> getAllRelevantIssueTypeIds() {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeIds();
        }
        return CollectionUtil.transform(this.constantsManager.getRegularIssueTypeObjects().iterator(), (Function)new Function<IssueType, String>(){

            public String get(IssueType input) {
                return input.getId();
            }
        });
    }

    private class ConfigurationSchemeCacheLoader
    implements CacheLoader<Long, ImmutableFieldConfigurationScheme> {
        private ConfigurationSchemeCacheLoader() {
        }

        public ImmutableFieldConfigurationScheme load(@Nonnull Long schemeId) {
            GenericValue fieldLayoutSchemeGV = DefaultFieldLayoutManager.this.ofBizDelegator.findById(DefaultFieldLayoutManager.FIELD_LAYOUT_SCHEME_ASSOCIATION, schemeId);
            if (fieldLayoutSchemeGV == null) {
                throw new DataAccessException("No FieldLayoutScheme found for id " + schemeId);
            }
            return DefaultFieldLayoutManager.this.buildFieldConfigurationScheme(fieldLayoutSchemeGV);
        }
    }

    private class FieldSchemeCacheLoader
    implements CacheLoader<Long, CacheObject<Long>> {
        private FieldSchemeCacheLoader() {
        }

        public CacheObject<Long> load(@Nonnull Long projectId) {
            GenericValue fieldLayoutSchemeGV = EntityUtil.getOnly(DefaultFieldLayoutManager.this.nodeAssociationStore.getSinksFromSource(DefaultFieldLayoutManager.PROJECT_ENTITY_NAME, projectId, DefaultFieldLayoutManager.FIELD_LAYOUT_SCHEME_ASSOCIATION, "ProjectScheme"));
            if (fieldLayoutSchemeGV != null) {
                return new CacheObject<Long>(fieldLayoutSchemeGV.getLong("id"));
            }
            return new CacheObject<Object>(null);
        }
    }

    private class DefaultFieldConfigurationScheme
    implements FieldConfigurationScheme {
        private DefaultFieldConfigurationScheme() {
        }

        public Long getId() {
            return null;
        }

        public String getName() {
            return "Default Field Configuration Scheme";
        }

        public String getDescription() {
            return "";
        }

        public Long getFieldLayoutId(String issueTypeId) {
            return null;
        }

        public Set<Long> getAllFieldLayoutIds(Collection<String> allIssueTypeIds) {
            return Collections.singleton(null);
        }
    }
}

