/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public abstract class AbstractFieldLayoutManager
implements FieldLayoutManager,
Startable {
    private static final Logger log = Logger.getLogger(AbstractFieldLayoutManager.class);
    public static final String SCHEME = "FieldLayoutScheme";
    public static final String SCHEME_ASSOCIATION = "ProjectFieldLayoutScheme";
    private final FieldManager fieldManager;
    private List<FieldLayoutItem> defaultFieldLayoutItems;
    private final Cache<CacheObject<Long>, FieldLayout> fieldLayoutCache;
    protected OfBizDelegator ofBizDelegator;

    public AbstractFieldLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, I18nHelper.BeanFactory i18n, CacheManager cacheManager) {
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.ofBizDelegator = ofBizDelegator;
        this.fieldLayoutCache = cacheManager.getCache(AbstractFieldLayoutManager.class.getName() + ".fieldLayoutCache", (CacheLoader)new FieldLayoutCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void start() throws Exception {
        this.defaultFieldLayoutItems = this.getDefaultFieldLayoutItems();
    }

    @EventListener
    public void onCustomFieldUpdated(CustomFieldUpdatedEvent event) {
        this.invalidateFieldLayoutItemsContaining(event.getCustomFieldId());
    }

    protected List<FieldLayoutItem> getDefaultFieldLayoutItems() {
        return CollectionBuilder.newBuilder((Object[])new FieldLayoutItem[]{this.createFieldLayoutItemImpl("summary", true), this.createFieldLayoutItemImpl("issuetype", true), this.createFieldLayoutItemImpl("security", false), this.createFieldLayoutItemImpl("priority", false), this.createFieldLayoutItemImpl("duedate", false), this.createFieldLayoutItemImpl("components", false), this.createFieldLayoutItemImpl("versions", false), this.createFieldLayoutItemImpl("fixVersions", false), this.createFieldLayoutItemImpl("assignee", false), this.createFieldLayoutItemImpl("reporter", true), this.createFieldLayoutItemImpl("environment", false), this.createFieldLayoutItemImpl("description", false), this.createFieldLayoutItemImpl("timetracking", false), this.createFieldLayoutItemImpl("resolution", false), this.createFieldLayoutItemImpl("attachment", false), this.createFieldLayoutItemImpl("comment", false), this.createFieldLayoutItemImpl("labels", false), this.createFieldLayoutItemImpl("worklog", false), this.createFieldLayoutItemImpl("issuelinks", false)}).asList();
    }

    private FieldLayoutItem createFieldLayoutItemImpl(String fieldId, boolean required) {
        return new FieldLayoutItemImpl.Builder().setOrderableField(this.fieldManager.getOrderableField(fieldId)).setFieldDescription(this.getDefaultDescription(fieldId)).setHidden(false).setRequired(required).setFieldManager(this.fieldManager).build();
    }

    public FieldLayout getFieldLayout() {
        return this.getRelevantFieldLayout(null);
    }

    public FieldLayout getFieldLayout(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null.");
        }
        return this.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeObject().getId());
    }

    public EditableDefaultFieldLayout getEditableDefaultFieldLayout() {
        FieldLayout relevantFieldLayout = this.getRelevantFieldLayout(null);
        return new EditableDefaultFieldLayoutImpl(relevantFieldLayout.getGenericValue(), relevantFieldLayout.getFieldLayoutItems());
    }

    public void storeEditableDefaultFieldLayout(EditableDefaultFieldLayout editableDefaultFieldLayout) {
        this.storeEditableFieldLayout((EditableFieldLayout)editableDefaultFieldLayout);
        this.refreshCaches(editableDefaultFieldLayout.getId());
        this.refreshCaches(null);
    }

    public synchronized EditableFieldLayout storeAndReturnEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        try {
            OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
            GenericValue fieldLayoutGV = editableFieldLayout.getGenericValue();
            if (editableFieldLayout.getGenericValue() == null) {
                fieldLayoutGV = EntityUtils.createValue("FieldLayout", MapBuilder.build((Object)"name", (Object)editableFieldLayout.getName(), (Object)"description", (Object)editableFieldLayout.getDescription(), (Object)"type", (Object)editableFieldLayout.getType()));
            } else {
                fieldLayoutGV.store();
            }
            List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
            ofBizDelegator.removeAll(fieldLayoutItemGVs);
            List fieldLayoutItems = editableFieldLayout.getFieldLayoutItems();
            Long newId = fieldLayoutGV.getLong("id");
            for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
                EntityUtils.createValue("FieldLayoutItem", MapBuilder.newBuilder().add((Object)"fieldlayout", (Object)newId).add((Object)"description", (Object)fieldLayoutItem.getRawFieldDescription()).add((Object)"fieldidentifier", (Object)fieldLayoutItem.getOrderableField().getId()).add((Object)"ishidden", (Object)Boolean.toString(fieldLayoutItem.isHidden())).add((Object)"isrequired", (Object)Boolean.toString(fieldLayoutItem.isRequired())).add((Object)"renderertype", (Object)fieldLayoutItem.getRendererType()).toMap());
            }
            this.refreshCaches(newId);
            return this.getEditableFieldLayout(newId);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Could not load the default FieldLayout", (Throwable)e);
        }
    }

    public void storeEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        this.storeAndReturnEditableFieldLayout(editableFieldLayout);
    }

    protected void refreshCaches(Long id) {
        this.fieldLayoutCache.remove(CacheObject.wrap(id));
        this.fieldManager.getColumnLayoutManager().refresh();
    }

    public boolean hasDefaultFieldLayout() {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        GenericValue fieldLayoutGV = EntityUtil.getOnly((List)ofBizDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
        return fieldLayoutGV == null;
    }

    public void restoreDefaultFieldLayout() {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        try {
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)ofBizDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
            if (fieldLayoutGV != null) {
                fieldLayoutGV.removeRelated("ChildFieldLayoutItem");
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    protected synchronized void restoreFieldLayout(Long id) {
        try {
            OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
            GenericValue fieldLayoutGV = EntityUtil.getOnly((List)ofBizDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"id", (Object)id)));
            if (fieldLayoutGV != null) {
                List fieldLayoutItemGVs = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
                ofBizDelegator.removeAll(fieldLayoutItemGVs);
                fieldLayoutGV.remove();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.refresh();
    }

    public void refresh() {
        this.fieldLayoutCache.removeAll();
    }

    protected FieldLayout getRelevantFieldLayout(Long id) {
        return (FieldLayout)this.fieldLayoutCache.get(CacheObject.wrap(id));
    }

    private FieldLayout loadFieldLayout(Long id) {
        try {
            ArrayList<Object> fieldLayoutItems;
            Set unavailableFields = this.fieldManager.getUnavailableFields();
            GenericValue fieldLayoutGV = null;
            if (id != null) {
                fieldLayoutGV = this.ofBizDelegator.findById("FieldLayout", id);
            }
            if (fieldLayoutGV == null) {
                fieldLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("FieldLayout", EasyMap.build((Object)"type", (Object)"default")));
            }
            FieldLayoutImpl resultingLayout = new FieldLayoutImpl(fieldLayoutGV, null);
            if (fieldLayoutGV == null) {
                fieldLayoutItems = new ArrayList<FieldLayoutItem>(this.defaultFieldLayoutItems);
                for (int i = 0; i < fieldLayoutItems.size(); ++i) {
                    fieldLayoutItems.set(i, new FieldLayoutItemImpl.Builder((FieldLayoutItem)fieldLayoutItems.get(i)).setFieldLayout(resultingLayout).build());
                }
                List customFieldObjects = ComponentAccessor.getCustomFieldManager().getCustomFieldObjects();
                for (CustomField customField : customFieldObjects) {
                    FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField((OrderableField)customField).setFieldDescription(null).setFieldLayout(resultingLayout);
                    fieldLayoutItems.add(builder.build());
                }
            } else {
                fieldLayoutItems = new ArrayList();
                List related = fieldLayoutGV.getRelated("ChildFieldLayoutItem");
                for (GenericValue fieldLayoutItemGV : related) {
                    String fieldId = fieldLayoutItemGV.getString("fieldidentifier");
                    if (this.fieldManager.isOrderableField(fieldId)) {
                        FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField(this.fieldManager.getOrderableField(fieldId)).setFieldDescription(fieldLayoutItemGV.getString("description")).setHidden(Boolean.valueOf(fieldLayoutItemGV.getString("ishidden"))).setRequired(Boolean.valueOf(fieldLayoutItemGV.getString("isrequired"))).setRendererType(fieldLayoutItemGV.getString("renderertype")).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager);
                        fieldLayoutItems.add(builder.build());
                        continue;
                    }
                    log.info((Object)("Field layout contains non-orderable field with id '" + fieldId + "'."));
                }
                Set orderableFields = this.fieldManager.getOrderableFields();
                for (OrderableField orderableField : orderableFields) {
                    boolean found = false;
                    for (FieldLayoutItem fieldLayoutItem : fieldLayoutItems) {
                        if (!orderableField.equals(fieldLayoutItem.getOrderableField())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    FieldLayoutItemImpl.Builder builder = new FieldLayoutItemImpl.Builder().setOrderableField(orderableField).setFieldDescription(this.getDefaultDescription(orderableField.getId())).setHidden(false).setRequired(this.fieldManager.isMandatoryField((Field)orderableField)).setFieldLayout(resultingLayout).setFieldManager(this.fieldManager);
                    fieldLayoutItems.add(builder.build());
                }
            }
            Iterator iterator = fieldLayoutItems.iterator();
            while (iterator.hasNext()) {
                FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)iterator.next();
                if (!unavailableFields.contains(fieldLayoutItem.getOrderableField())) continue;
                iterator.remove();
            }
            resultingLayout.setFieldLayoutItems(new ArrayList<Object>(fieldLayoutItems));
            return resultingLayout;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new DataAccessException("Could not retrieve Field Layout.", (Throwable)e);
        }
    }

    protected String getDefaultDescription(String fieldId) {
        I18nHelper i18n = this.getI18nHelper();
        if ("environment".equals(fieldId)) {
            return i18n.getText("environment.field.description");
        }
        if ("timetracking".equals(fieldId)) {
            return i18n.getText("timetracking.field.description", "*w *d *h *m", "4d, 5h 30m, 60m", "3w");
        }
        if ("worklog".equals(fieldId)) {
            return i18n.getText("worklog.field.description");
        }
        return null;
    }

    protected I18nHelper getI18nHelper() {
        return new I18nBean(ComponentAccessor.getApplicationProperties().getDefaultLocale());
    }

    private void invalidateFieldLayoutItemsContaining(String customFieldId) {
        for (CacheObject key : this.fieldLayoutCache.getKeys()) {
            if (((FieldLayout)this.fieldLayoutCache.get((Object)key)).getFieldLayoutItem(customFieldId) == null) continue;
            this.refreshCaches((Long)key.getValue());
        }
    }

    private class FieldLayoutCacheLoader
    implements CacheLoader<CacheObject<Long>, FieldLayout> {
        private FieldLayoutCacheLoader() {
        }

        public FieldLayout load(CacheObject<Long> from) {
            return AbstractFieldLayoutManager.this.loadFieldLayout(from.getValue());
        }
    }
}

