/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.TransformedKeyCache;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersisterImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.util.concurrent.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachedFieldConfigSchemePersister
extends FieldConfigSchemePersisterImpl {
    private final Cache<Long, CacheObject<FieldConfigScheme>> cacheById;
    private final TransformedKeyCache<ConfigurableField, String, CacheObject<List<FieldConfigScheme>>> cacheByCustomField;
    private final TransformedKeyCache<FieldConfig, Long, FieldConfigScheme> cacheByFieldConfig;

    public CachedFieldConfigSchemePersister(OfBizDelegator delegator, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister fieldContextPersister, CacheManager cacheManager) {
        super(delegator, constantsManager, fieldConfigPersister, fieldContextPersister);
        this.cacheById = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheById", (CacheLoader)new FiledConfigByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        Cache internalCacheByCustomField = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheByCustomField", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByCustomField = TransformedKeyCache.transform(internalCacheByCustomField, new ConfigurableFieldKeyTransformer(), new FieldConfigSchemeByFieldCacheLoader());
        Cache internalCacheByFieldConfig = cacheManager.getCache(CachedFieldConfigSchemePersister.class.getName() + ".cacheByFieldConfig", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByFieldConfig = TransformedKeyCache.transform(internalCacheByFieldConfig, new FieldConfigKeyTransformerFunction(), new FieldConfigSchemeBySchemeCacheLoader());
        super.init();
    }

    @Override
    public synchronized void init() {
        super.init();
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @Override
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId == null) {
            return null;
        }
        return (FieldConfigScheme)((CacheObject)this.cacheById.get((Object)configSchemeId)).getValue();
    }

    @Override
    public List<FieldConfigScheme> getConfigSchemesForCustomField(ConfigurableField field) {
        if (field == null) {
            return null;
        }
        return this.cacheByCustomField.get(field).getValue();
    }

    @Override
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        return this.cacheByFieldConfig.get(fieldConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(Long fieldConfigSchemeId) {
        FieldConfigScheme fieldConfigScheme = null;
        try {
            fieldConfigScheme = super.removeIfExist(fieldConfigSchemeId);
        }
        finally {
            this.cacheById.remove((Object)fieldConfigSchemeId);
            if (fieldConfigScheme != null) {
                ConfigurableField field = fieldConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove(field);
                }
                Map configs = fieldConfigScheme.getConfigs();
                for (FieldConfig config : configs.values()) {
                    this.cacheByFieldConfig.remove(config);
                }
            }
        }
    }

    private class FieldConfigSchemeBySchemeCacheLoader
    implements CacheLoader<FieldConfig, FieldConfigScheme> {
        private FieldConfigSchemeBySchemeCacheLoader() {
        }

        public FieldConfigScheme load(@NotNull FieldConfig fieldConfig) {
            return CachedFieldConfigSchemePersister.super.getConfigSchemeForFieldConfig(fieldConfig);
        }
    }

    private class FieldConfigSchemeByFieldCacheLoader
    implements CacheLoader<ConfigurableField, CacheObject<List<FieldConfigScheme>>> {
        private FieldConfigSchemeByFieldCacheLoader() {
        }

        public CacheObject<List<FieldConfigScheme>> load(@NotNull ConfigurableField field) {
            List schemes = CollectionUtil.copyAsImmutableList((Collection)CachedFieldConfigSchemePersister.super.getConfigSchemesForCustomField(field));
            return CacheObject.wrap(schemes);
        }
    }

    private class FiledConfigByIdCacheLoader
    implements CacheLoader<Long, CacheObject<FieldConfigScheme>> {
        private FiledConfigByIdCacheLoader() {
        }

        public CacheObject<FieldConfigScheme> load(@Nonnull Long configSchemeId) {
            FieldConfigScheme scheme = CachedFieldConfigSchemePersister.super.getFieldConfigScheme(configSchemeId);
            return CacheObject.wrap(scheme);
        }
    }

    private static class FieldConfigKeyTransformerFunction
    implements Function<FieldConfig, Long> {
        private FieldConfigKeyTransformerFunction() {
        }

        public Long get(FieldConfig fieldConfig) {
            return fieldConfig.getId();
        }
    }

    private static class ConfigurableFieldKeyTransformer
    implements Function<ConfigurableField, String> {
        private ConfigurableFieldKeyTransformer() {
        }

        public String get(ConfigurableField configurableField) {
            return configurableField.getId();
        }
    }
}

