/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.bandana.DefaultBandanaManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class FieldConfigSchemeManagerImpl
implements FieldConfigSchemeManager {
    private static final Logger log = Logger.getLogger(FieldConfigSchemeManagerImpl.class);
    private final FieldConfigManager configManager;
    private final FieldConfigSchemePersister schemePersister;
    private final FieldConfigContextPersister contextPersister;
    private final DefaultBandanaManager defaultBandanaManager;
    private final JiraContextTreeManager treeManager;

    public FieldConfigSchemeManagerImpl(FieldConfigSchemePersister configSchemePersister, FieldConfigContextPersister contextPersister, JiraContextTreeManager treeManager, FieldConfigManager configManager) {
        this.defaultBandanaManager = new DefaultBandanaManager((BandanaPersister)contextPersister);
        this.schemePersister = configSchemePersister;
        this.contextPersister = contextPersister;
        this.treeManager = treeManager;
        this.configManager = configManager;
    }

    public void init() {
        this.defaultBandanaManager.init();
        this.schemePersister.init();
    }

    public Object getValue(BandanaContext context, String key) {
        return this.getValue(context, key, true);
    }

    public Object getValue(BandanaContext context, String key, boolean lookUp) {
        Long configSchemeId = (Long)this.defaultBandanaManager.getValue(context, key, lookUp);
        if (configSchemeId != null) {
            return this.schemePersister.getFieldConfigScheme(configSchemeId);
        }
        return null;
    }

    public void setValue(BandanaContext context, String key, Object value) {
        this.contextPersister.store(context, key, value);
    }

    public List<FieldConfigScheme> getConfigSchemesForField(ConfigurableField field) {
        return this.schemePersister.getConfigSchemesForCustomField(field);
    }

    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        try {
            return this.schemePersister.getConfigSchemeForFieldConfig(fieldConfig);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId != null) {
            return this.schemePersister.getFieldConfigScheme(configSchemeId);
        }
        return null;
    }

    private FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, ConfigurableField field) {
        FieldConfigScheme configScheme = this.schemePersister.create(newConfigScheme, field);
        if (contexts != null && !contexts.isEmpty()) {
            this.storeAssociateContexts(configScheme, contexts, field);
        } else {
            log.info((Object)("ConfigScheme " + configScheme.getName() + " (" + configScheme.getId() + "). Created with no associated contexts"));
        }
        return configScheme;
    }

    public FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, List<GenericValue> issueTypes, ConfigurableField field) {
        FieldConfigScheme.Builder builder = new FieldConfigScheme.Builder(newConfigScheme);
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            FieldConfig config = this.configManager.createWithDefaultValues(field);
            HashMap<String, FieldConfig> issueTypesMappings = new HashMap<String, FieldConfig>(issueTypes.size());
            for (GenericValue issueTypeGv : issueTypes) {
                String issueTypeId = issueTypeGv == null ? null : issueTypeGv.getString("id");
                issueTypesMappings.put(issueTypeId, config);
            }
            builder.setConfigs(issueTypesMappings);
        }
        return this.createFieldConfigScheme(builder.toFieldConfigScheme(), contexts, field);
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts, List<GenericValue> issueTypes) {
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            FieldConfig config = this.configManager.createWithDefaultValues(field);
            HashMap<String, FieldConfig> issueTypesMappings = new HashMap<String, FieldConfig>(issueTypes.size());
            for (GenericValue issueTypeGv : issueTypes) {
                String issueTypeId = issueTypeGv == null ? null : issueTypeGv.getString("id");
                issueTypesMappings.put(issueTypeId, config);
            }
            FieldConfigScheme defaultScheme = this.schemePersister.createWithDefaultValues(field, issueTypesMappings);
            if (contexts != null && !contexts.isEmpty()) {
                this.storeAssociateContexts(defaultScheme, contexts, field);
            } else {
                log.info((Object)("ConfigScheme " + defaultScheme.getName() + " (" + defaultScheme.getId() + "). Created with no associated contexts"));
            }
            return defaultScheme;
        }
        log.info((Object)"Incomplete information supplied. Default scheme not created.");
        return null;
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts) {
        return this.createDefaultScheme(field, contexts, ALL_ISSUE_TYPES);
    }

    public void removeSchemeAssociation(List<JiraContextNode> contexts, ConfigurableField configurableField) {
        for (JiraContextNode contextNode : contexts) {
            this.setValue((BandanaContext)contextNode, configurableField.getId(), null);
        }
    }

    public List<GenericValue> getAssociatedProjects(ConfigurableField field) {
        List<FieldConfigScheme> configurations = this.getConfigSchemesForField(field);
        LinkedList projects = new LinkedList();
        if (configurations != null) {
            for (FieldConfigScheme config : configurations) {
                List configProject = config.getAssociatedProjects();
                if (configProject == null) continue;
                projects.addAll(configProject);
            }
            Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
        }
        return Collections.unmodifiableList(projects);
    }

    public List<Project> getAssociatedProjectObjects(ConfigurableField field) {
        List<FieldConfigScheme> configurations = this.getConfigSchemesForField(field);
        LinkedList projects = new LinkedList();
        if (configurations != null) {
            for (FieldConfigScheme config : configurations) {
                List configProject = config.getAssociatedProjectObjects();
                if (configProject == null) continue;
                projects.addAll(configProject);
            }
            Collections.sort(projects, NameComparator.COMPARATOR);
        }
        return Collections.unmodifiableList(projects);
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme newScheme, List<JiraContextNode> contexts, ConfigurableField field) {
        FieldConfigScheme configScheme = this.updateFieldConfigScheme(newScheme);
        this.contextPersister.removeContextsForConfigScheme(newScheme.getId());
        this.storeAssociateContexts(configScheme, contexts, field);
        return configScheme;
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme scheme) {
        return this.schemePersister.update(scheme);
    }

    public void removeFieldConfigScheme(Long fieldConfigSchemeId) {
        this.contextPersister.removeContextsForConfigScheme(fieldConfigSchemeId);
        this.configManager.removeConfigsForConfigScheme(fieldConfigSchemeId);
        this.schemePersister.remove(fieldConfigSchemeId);
    }

    public void removeInvalidFieldConfigSchemesForIssueType(IssueType issueType) {
        Collection fieldConfigSchemes = this.getInvalidFieldConfigSchemesForIssueTypeRemoval(issueType);
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            this.removeFieldConfigScheme(fieldConfigScheme.getId());
        }
        this.schemePersister.removeByIssueType(issueType);
    }

    public void removeInvalidFieldConfigSchemesForCustomField(String customFieldId) {
        List<Long> schemeIds = this.schemePersister.getConfigSchemeIdsForCustomFieldId(customFieldId);
        for (Long schemeId : schemeIds) {
            this.removeFieldConfigScheme(schemeId);
        }
    }

    public Collection getInvalidFieldConfigSchemesForIssueTypeRemoval(IssueType issueType) {
        Null.not("issueType", issueType);
        return this.schemePersister.getInvalidFieldConfigSchemeAfterIssueTypeRemoval(issueType);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext, ConfigurableField field) {
        FieldConfigScheme scheme = this.getRelevantConfigScheme(issueContext, field);
        if (scheme != null) {
            Map configs = scheme.getConfigs();
            if (configs != null) {
                FieldConfig configForAnyIssueType = (FieldConfig)configs.get(null);
                if (configForAnyIssueType != null) {
                    return configForAnyIssueType;
                }
                IssueType issueType = issueContext.getIssueTypeObject();
                String issueTypeId = issueType == null ? null : issueType.getId();
                FieldConfig config = (FieldConfig)configs.get(issueTypeId);
                if (config != null) {
                    return config;
                }
            }
            return null;
        }
        return null;
    }

    public FieldConfigScheme getRelevantConfigScheme(IssueContext issueContext, ConfigurableField field) {
        ProjectContext context = new ProjectContext(issueContext, this.treeManager);
        return (FieldConfigScheme)this.getValue((BandanaContext)context, field.getId());
    }

    FieldConfigSchemePersister getFieldConfigSchemePersister() {
        return this.schemePersister;
    }

    private void storeAssociateContexts(FieldConfigScheme config, List<JiraContextNode> contexts, ConfigurableField field) {
        this.contextPersister.store(contexts, field.getId(), (Object)config);
    }
}

