/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.IssueLinkTypeFinder;
import com.atlassian.jira.issue.fields.rest.IssueLinksRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.link.IssueLinkDisplayHelper;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import webwork.action.Action;

public class IssueLinksSystemField
extends AbstractOrderableField
implements HideableField,
RequirableField,
NavigableField,
RestAwareField,
RestFieldOperations {
    public static final String PARAMS_ISCREATEISSUE = "isCreateIssue";
    public static final String PARAMS_LINK_TYPE = "issuelinks-linktype";
    public static final String PARAMS_ISSUE_KEYS = "issuelinks-issues";
    private static final String NAME_KEY = "issue.field.issuelinks";
    private final IssueLinkService issueLinkService;
    private final IssueLinkManager issueLinkManager;
    private final UserHistoryManager userHistoryManager;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final IssueLinkTypeFinder issueLinkTypeFinder;
    private final JiraBaseUrls jiraBaseUrls;

    public IssueLinksSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, IssueLinkService issueLinkService, UserHistoryManager userHistoryManager, IssueLinkManager issueLinkManager, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, I18nHelper.BeanFactory i18nFactory, IssueLinkTypeFinder issueLinkTypeFinder, JiraBaseUrls jiraBaseUrls) {
        super("issuelinks", NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, null);
        this.issueLinkService = issueLinkService;
        this.userHistoryManager = userHistoryManager;
        this.issueLinkManager = issueLinkManager;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.i18nFactory = i18nFactory;
        this.issueLinkTypeFinder = issueLinkTypeFinder;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public LuceneFieldSorter getSorter() {
        return null;
    }

    public List<SortField> getSortFields(boolean sortOrder) {
        return Collections.emptyList();
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, null, issue, displayParams);
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, this.authenticationContext.getLoggedInUser());
        velocityParams.put("linkedIssues", linkCollection.getAllIssues());
        velocityParams.put("applicationProperties", this.getApplicationProperties());
        return this.renderTemplate("issuelinks-columnview.vm", velocityParams);
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getCreateOrEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters, Boolean.TRUE);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getCreateOrEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters, Boolean.FALSE);
    }

    private String getCreateOrEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters, Boolean create) {
        IssueLinkingValue ilv;
        IssueLinkDisplayHelper issueLinkDisplayHelper = new IssueLinkDisplayHelper(this.userHistoryManager, this.authenticationContext.getLoggedInUser());
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put(PARAMS_ISCREATEISSUE, create);
        Object value = operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("value", value);
        velocityParams.put("linkTypes", issueLinkDisplayHelper.getSortedIssueLinkTypes(this.issueLinkService.getIssueLinkTypes()));
        velocityParams.put("selectedLinkType", issueLinkDisplayHelper.getLastUsedLinkType());
        if (value != null && value instanceof IssueLinkingValue && StringUtils.isNotBlank((String)(ilv = (IssueLinkingValue)value).getLinkDescription())) {
            velocityParams.put("selectedLinkType", ilv.getLinkDescription());
        }
        return this.renderTemplate("issuelinks-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        this.populateFromIssue(velocityParams, issue);
        return this.getViewVelocityTemplate(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put(this.getId(), value);
        return this.getViewVelocityTemplate(velocityParams);
    }

    private String getViewVelocityTemplate(Map velocityParams) {
        return this.renderTemplate("issuelinking-view.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        return "TODO";
    }

    public void createValue(Issue issue, Object value) {
        IssueLinkingValue issueLinkingValue;
        IssueLinkService.AddIssueLinkValidationResult validationResult;
        if (this.isIssueLinkingEnabled() && (validationResult = (issueLinkingValue = (IssueLinkingValue)value).getValidationResult()) != null && validationResult.isValid()) {
            this.issueLinkService.addIssueLinks(this.authenticationContext.getLoggedInUser(), validationResult);
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), new IssueLinkingValue.Builder().setIssueLinkingEnabled(this.isIssueLinkingEnabled()).build());
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> inputParameters) {
        IssueLinkingValue.Builder builder = new IssueLinkingValue.Builder();
        builder.setIssueLinkingEnabled(this.isIssueLinkingEnabled());
        builder.setCreateIssue(inputParameters.get(PARAMS_ISCREATEISSUE));
        builder.setLinkDescription(inputParameters.get(PARAMS_LINK_TYPE));
        builder.setLinkedIssues(inputParameters.get(PARAMS_ISSUE_KEYS));
        return builder.build();
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        IssueLinkingValue.Builder valueBuilder = new IssueLinkingValue.Builder();
        valueBuilder.setIssueLinkingEnabled(this.isIssueLinkingEnabled());
        fieldValuesHolder.put(this.getId(), valueBuilder.build());
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollection, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        IssueLinkingValue value = (IssueLinkingValue)operationContext.getFieldValuesHolder().get(this.getId());
        if (this.isIssueLinkingEnabled() && value != null && !value.getLinkedIssues().isEmpty()) {
            IssueLinkService.AddIssueLinkValidationResult issueLinkValidationResult = this.issueLinkService.validateAddIssueLinks(this.authenticationContext.getLoggedInUser(), issue, value.getLinkDescription(), value.getLinkedIssues());
            if (issueLinkValidationResult.isValid()) {
                operationContext.getFieldValuesHolder().put(this.getId(), new IssueLinkingValue.Builder(issueLinkValidationResult).build());
            } else {
                this.transferErrorMessages(errorCollection, issueLinkValidationResult.getErrorCollection().getErrorMessages());
                this.transferErrorMessages(errorCollection, issueLinkValidationResult.getErrorCollection().getErrors().values());
            }
        }
    }

    private void transferErrorMessages(ErrorCollection errorCollection, Collection<String> errorMessages) {
        for (String errMsg : errorMessages) {
            errorCollection.addError(this.getId(), errMsg);
        }
    }

    public Object getValueFromParams(Map fieldValueHolder) {
        return fieldValueHolder.get(this.getId());
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        IssueLinkingValue newValue = (IssueLinkingValue)this.getValueFromParams(fieldValueHolder);
        if (newValue == null) {
            return;
        }
        if (this.isIssueLinkingEnabled()) {
            issue.setExternalFieldValue(this.getId(), null, (Object)newValue);
        }
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        IssueLinkingValue issueLinkingValue;
        IssueLinkService.AddIssueLinkValidationResult validationResult;
        Object newValue = modifiedValue.getNewValue();
        if (newValue != null && this.isIssueLinkingEnabled() && (validationResult = (issueLinkingValue = (IssueLinkingValue)newValue).getValidationResult()) != null && validationResult.isValid()) {
            this.issueLinkService.addIssueLinks(this.authenticationContext.getLoggedInUser(), validationResult);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
    }

    public boolean isShown(Issue issue) {
        return this.isIssueLinkingEnabled() && this.hasPermission(issue, 21);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return false;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.issuelinks";
    }

    public String getColumnCssClass() {
        return this.getId();
    }

    public String getDefaultSortOrder() {
        return null;
    }

    public FieldComparatorSource getSortComparatorSource() {
        LuceneFieldSorter sorter = this.getSorter();
        if (sorter == null) {
            return null;
        }
        return new MappedSortComparator(sorter);
    }

    public String getHiddenFieldId() {
        return null;
    }

    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String issueLinksAutoCompleteUrl = fieldTypeInfoContext.getIssue() == null ? String.format("%s/rest/api/1.0/issues/picker?currentProjectId=%s&showSubTaskParent=true&showSubTasks=true&currentIssueKey=&query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getIssueContext().getProjectObject().getId()) : String.format("%s/rest/api/1.0/issues/picker?currentProjectId=&showSubTaskParent=true&showSubTasks=true&currentIssueKey=%s&query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getIssue().getKey());
        return new FieldTypeInfo(null, issueLinksAutoCompleteUrl);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"issuelinks", (String)"issuelinks");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        if (!this.issueLinkManager.isLinkingEnabled()) {
            return null;
        }
        IssueLinksBeanBuilder builder = this.issueLinkBeanBuilderFactory.newIssueLinksBeanBuilder(issue);
        return new FieldJsonRepresentation(new JsonData((Object)builder.buildIssueLinks()));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        IssueFinder issueFinder = (IssueFinder)ComponentAccessor.getComponent(IssueFinder.class);
        return new IssueLinksRestFieldOperationsHandler(this.i18nFactory.getInstance(this.authenticationContext.getLoggedInUser()), this.issueLinkTypeFinder, issueFinder);
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }

    private boolean isIssueLinkingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.issuelinking");
    }

    @Internal
    public static interface IssueLinkingValue {
        public boolean isCreateIssue();

        public boolean isIssueLinkingActivated();

        public String getLinkDescription();

        public List<String> getLinkedIssues();

        public IssueLinkService.AddIssueLinkValidationResult getValidationResult();

        public static class Builder {
            private String linkDesc = null;
            private List<String> linkedIssues;
            private boolean isIssueLinkingEnabled;
            private boolean isCreateIssue = false;
            private IssueLinkService.AddIssueLinkValidationResult validationResult;

            Builder() {
            }

            Builder(IssueLinkService.AddIssueLinkValidationResult validationResult) {
                this.validationResult = validationResult;
            }

            Builder setCreateIssue(String[] createIssue) {
                String s = this.fromArray(createIssue);
                this.isCreateIssue = StringUtils.isNotBlank((String)s) ? Boolean.valueOf(s) : false;
                return this;
            }

            Builder setIssueLinkingEnabled(boolean enabled) {
                this.isIssueLinkingEnabled = enabled;
                return this;
            }

            Builder setLinkDescription(String[] value) {
                this.linkDesc = this.fromArray(value);
                return this;
            }

            Builder setLinkedIssues(String[] value) {
                if (value != null) {
                    this.linkedIssues = new ArrayList<String>();
                    this.linkedIssues.addAll(Arrays.asList(value));
                }
                return this;
            }

            private String fromArray(String[] value) {
                return value != null && value.length > 0 ? value[0] : null;
            }

            IssueLinkingValue build() {
                final boolean isCreateIssue = this.isCreateIssue;
                final boolean isIssueLinkingEnabled = this.isIssueLinkingEnabled;
                final String linkDesc = this.linkDesc;
                final List<Object> linkedIssues = this.linkedIssues == null ? Collections.emptyList() : this.linkedIssues;
                return new IssueLinkingValue(){

                    @Override
                    public boolean isCreateIssue() {
                        return isCreateIssue;
                    }

                    @Override
                    public boolean isIssueLinkingActivated() {
                        return isIssueLinkingEnabled;
                    }

                    @Override
                    public String getLinkDescription() {
                        return linkDesc;
                    }

                    @Override
                    public List<String> getLinkedIssues() {
                        return linkedIssues;
                    }

                    @Override
                    public IssueLinkService.AddIssueLinkValidationResult getValidationResult() {
                        return Builder.this.validationResult;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (!(obj instanceof IssueLinkingValue)) {
                            return false;
                        }
                        IssueLinkingValue rhs = (IssueLinkingValue)obj;
                        return new EqualsBuilder().append(isCreateIssue, rhs.isCreateIssue()).append(isIssueLinkingEnabled, rhs.isIssueLinkingActivated()).append((Object)linkDesc, (Object)rhs.getLinkDescription()).append((Object)linkedIssues, (Object)rhs.getLinkDescription()).isEquals();
                    }

                    public int hashCode() {
                        return new HashCodeBuilder(17, 31).append(isIssueLinkingEnabled).append(isCreateIssue).append((Object)linkDesc).append((Object)linkedIssues).toHashCode();
                    }

                    public String toString() {
                        return new ToStringBuilder((Object)this).append("isIssueLinkingEnabled", isIssueLinkingEnabled).append(IssueLinksSystemField.PARAMS_ISCREATEISSUE, isCreateIssue).append("linkDesc", (Object)linkDesc).append("linkedIssues", (Object)linkedIssues).toString();
                    }
                };
            }
        }
    }
}

